/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.model.instance;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import storm.trident.tuple.TridentTuple;
import stormy.pythian.model.instance.FeatureFunction;
import stormy.pythian.model.instance.FeatureProcedure;
import stormy.pythian.model.instance.InputFixedFeaturesMapper;
import stormy.pythian.model.instance.InputUserSelectionFeaturesMapper;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;
import stormy.pythian.model.instance.OutputUserSelectionFeaturesMapper;

public class Instance
implements Serializable {
    private static final long serialVersionUID = 4970738933759230736L;
    public static final String INSTANCE_FIELD = "INSTANCE_FIELD";
    public static final String NEW_INSTANCE_FIELD = "NEW_INSTANCE_FIELD";
    private final Object label;
    private final Object[] features;

    public static Instance from(TridentTuple tuple) {
        try {
            return (Instance)tuple.getValueByField(INSTANCE_FIELD);
        }
        catch (Exception ex) {
            throw new IllegalStateException("No instance found in tuple " + tuple, ex);
        }
    }

    public static Instance newInstance(OutputFixedFeaturesMapper mapper, Map<String, Object> newFeaturesWithName) {
        Object[] newFeatures = new Object[mapper.size()];
        for (String featureName : newFeaturesWithName.keySet()) {
            int index = mapper.getFeatureIndex(featureName);
            if (index < 0) {
                throw new IllegalArgumentException("Feature " + featureName + " does not exist");
            }
            newFeatures[index] = newFeaturesWithName.get(featureName);
        }
        return new Instance(null, newFeatures);
    }

    public static Instance newInstance(OutputUserSelectionFeaturesMapper mapper, List<?> features) {
        Object[] newFeatures = new Object[mapper.size()];
        for (int i = 0; i < mapper.size(); ++i) {
            newFeatures[i] = features.get(i);
        }
        return new Instance(null, newFeatures);
    }

    public static Instance newInstance(OutputFixedFeaturesMapper mapper, Object label, Map<String, Object> newFeaturesWithName) {
        Object[] newFeatures = new Object[mapper.size()];
        for (String featureName : newFeaturesWithName.keySet()) {
            int index = mapper.getFeatureIndex(featureName);
            if (index < 0) {
                throw new IllegalArgumentException("Feature " + featureName + " does not exist");
            }
            newFeatures[index] = newFeaturesWithName.get(featureName);
        }
        return new Instance(label, newFeatures);
    }

    Instance() {
        this.features = new Object[0];
        this.label = null;
    }

    Instance(Object label, int size) {
        this.label = label;
        this.features = new Object[size];
    }

    Instance(Object label, Object[] features) {
        this.label = label;
        this.features = features;
    }

    public <T> T getInputFeature(InputFixedFeaturesMapper inputFixedFeaturesMapper, String featureName) {
        int index = inputFixedFeaturesMapper.getFeatureIndex(featureName);
        return (T)(index < 0 ? null : this.features[index]);
    }

    public <T> T getOutputFeature(OutputFixedFeaturesMapper outputMapper, String featureName) {
        int index = outputMapper.getFeatureIndex(featureName);
        return (T)(index < 0 ? null : this.features[index]);
    }

    public <T> Instance withFeature(InputFixedFeaturesMapper inputFixedFeaturesMapper, String featureName, T feature) {
        int index = inputFixedFeaturesMapper.getFeatureIndex(featureName);
        if (index < 0) {
            throw new IllegalArgumentException("Feature " + featureName + " does not exist");
        }
        Object[] newFeatures = new Object[this.features.length];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        newFeatures[index] = feature;
        return new Instance(this.label, newFeatures);
    }

    public Instance withFeatures(InputFixedFeaturesMapper inputFixedFeaturesMapper, Map<String, Object> newFeaturesWithName) {
        Object[] newFeatures = new Object[this.features.length];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        for (String featureName : newFeaturesWithName.keySet()) {
            int index = inputFixedFeaturesMapper.getFeatureIndex(featureName);
            if (index < 0) {
                throw new IllegalArgumentException("Feature " + featureName + " does not exist");
            }
            newFeatures[index] = newFeaturesWithName.get(featureName);
        }
        return new Instance(this.label, newFeatures);
    }

    public <T> Instance withFeature(OutputFixedFeaturesMapper mapper, String featureName, T feature) {
        int index = mapper.getFeatureIndex(featureName);
        if (index < 0) {
            throw new IllegalArgumentException("Feature " + featureName + " does not exist");
        }
        Object[] newFeatures = new Object[mapper.size()];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        newFeatures[index] = feature;
        return new Instance(this.label, newFeatures);
    }

    public Instance withFeatures(OutputFixedFeaturesMapper mapper, Map<String, Object> newFeaturesWithName) {
        Object[] newFeatures = new Object[mapper.size()];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        for (String featureName : newFeaturesWithName.keySet()) {
            int index = mapper.getFeatureIndex(featureName);
            if (index < 0) {
                throw new IllegalArgumentException("Feature " + featureName + " does not exist");
            }
            newFeatures[index] = newFeaturesWithName.get(featureName);
        }
        return new Instance(this.label, newFeatures);
    }

    public Instance withFeatures(OutputUserSelectionFeaturesMapper mapper, Object ... newFeatures) {
        Object[] newFeaturesArray = new Object[mapper.size()];
        System.arraycopy(this.features, 0, newFeaturesArray, 0, this.features.length);
        int[] newFeatureIndexes = mapper.getNewFeatureIndexes();
        for (int i = 0; i < newFeatureIndexes.length; ++i) {
            Object newFeature;
            int index = newFeatureIndexes[i];
            newFeaturesArray[index] = newFeature = newFeatures[i];
        }
        return new Instance(this.label, newFeaturesArray);
    }

    public Instance withLabel(Object label) {
        Object[] newFeatures = new Object[this.features.length];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        return new Instance(this.label, newFeatures);
    }

    public Object[] getSelectedFeatures(InputUserSelectionFeaturesMapper inputUserSelectionFeaturesMapper) {
        int[] selectedIndex = inputUserSelectionFeaturesMapper.getSelectedIndex();
        Object[] selectedFeatures = new Object[selectedIndex.length];
        int i = 0;
        for (int index : selectedIndex) {
            selectedFeatures[i] = this.features[index];
            ++i;
        }
        return selectedFeatures;
    }

    public <T> void process(InputUserSelectionFeaturesMapper inputUserSelectionFeaturesMapper, FeatureProcedure<T> featureProcedure) {
        int[] selectedIndex;
        for (int index : selectedIndex = inputUserSelectionFeaturesMapper.getSelectedIndex()) {
            featureProcedure.process(this.features[index]);
        }
    }

    public <T> Instance transform(InputUserSelectionFeaturesMapper inputUserSelectionFeaturesMapper, FeatureFunction<T> function) {
        int[] selectedIndex;
        Object[] newFeatures = new Object[this.features.length];
        System.arraycopy(this.features, 0, newFeatures, 0, this.features.length);
        for (int index : selectedIndex = inputUserSelectionFeaturesMapper.getSelectedIndex()) {
            newFeatures[index] = function.transform(this.features[index]);
        }
        return new Instance(this.label, newFeatures);
    }

    public int size() {
        return this.features.length;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public Object getLabel() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.features);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instance other = (Instance)obj;
        if (!Arrays.equals(this.features, other.features)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    public String toString() {
        return "Instance [label=" + this.label + ", features=" + Arrays.toString(this.features) + "]";
    }
}

