/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.sandbox;

import backtype.storm.LocalCluster;
import backtype.storm.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import stormy.pythian.core.configuration.ComponentConfiguration;
import stormy.pythian.core.configuration.ConnectionConfiguration;
import stormy.pythian.core.configuration.InputStreamConfiguration;
import stormy.pythian.core.configuration.OutputStreamConfiguration;
import stormy.pythian.core.configuration.PythianStateConfiguration;
import stormy.pythian.core.configuration.PythianStateConfigurationTestBuilder;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;
import stormy.pythian.core.description.ComponentDescription;
import stormy.pythian.core.description.ComponentDescriptionFactory;
import stormy.pythian.core.description.InputStreamDescription;
import stormy.pythian.core.description.OutputStreamDescription;
import stormy.pythian.core.description.PythianStateDescription;
import stormy.pythian.core.description.PythianStateDescriptionFactory;
import stormy.pythian.core.ioc.CoreConfiguration;
import stormy.pythian.core.topology.PythianTopology;
import stormy.pythian.sandbox.ConsoleOutput;
import stormy.pythian.sandbox.RandomWordSource;
import stormy.pythian.sandbox.WordCount;
import stormy.pythian.state.TransactionMode;
import stormy.pythian.state.memory.InMemoryPythianState;

public class SandBox {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{CoreConfiguration.class});
        ComponentDescriptionFactory componentDescriptionFactory = (ComponentDescriptionFactory)context.getBean(ComponentDescriptionFactory.class);
        PythianStateDescriptionFactory stateDescriptionFactory = (PythianStateDescriptionFactory)context.getBean(PythianStateDescriptionFactory.class);
        PythianStateDescription inMemoryDescription = stateDescriptionFactory.createDescription(InMemoryPythianState.class);
        PythianStateConfiguration stateFactoryConfiguration = PythianStateConfigurationTestBuilder.stateConfiguration((PythianStateDescription)inMemoryDescription).with("Transaction mode", (Object)TransactionMode.NONE).with("Name", (Object)"Word count").build();
        ComponentDescription randomWordSource = componentDescriptionFactory.createDeclaration(RandomWordSource.class);
        ComponentConfiguration randomWordSourceConfiguration = new ComponentConfiguration(RandomStringUtils.randomAlphabetic((int)6), randomWordSource);
        randomWordSourceConfiguration.outputStreams.add(new OutputStreamConfiguration((OutputStreamDescription)randomWordSource.outputStreamDescriptions.get(0), SandBox.createMappings("word", "random word")));
        ComponentDescription wordCount = componentDescriptionFactory.createDeclaration(WordCount.class);
        ComponentConfiguration wordCountConfiguration = new ComponentConfiguration(RandomStringUtils.randomAlphabetic((int)6), wordCount);
        wordCountConfiguration.inputStreams.add(new InputStreamConfiguration((InputStreamDescription)wordCount.inputStreamDescriptions.get(0), SandBox.createMappings("word", "random word")));
        wordCountConfiguration.outputStreams.add(new OutputStreamConfiguration((OutputStreamDescription)wordCount.outputStreamDescriptions.get(0), SandBox.createMappings("count", "word count")));
        wordCountConfiguration.addStateFactory("count state", stateFactoryConfiguration);
        ComponentDescription consoleOutput = componentDescriptionFactory.createDeclaration(ConsoleOutput.class);
        ComponentConfiguration consoleOutputConfiguration = new ComponentConfiguration(RandomStringUtils.randomAlphabetic((int)6), consoleOutput);
        consoleOutputConfiguration.inputStreams.add(new InputStreamConfiguration((InputStreamDescription)consoleOutput.inputStreamDescriptions.get(0), Arrays.asList("random word", "word count")));
        LocalCluster cluster = new LocalCluster();
        PythianToplogyConfiguration topologyConfiguration = new PythianToplogyConfiguration();
        topologyConfiguration.getComponents().add(randomWordSourceConfiguration);
        topologyConfiguration.getComponents().add(wordCountConfiguration);
        topologyConfiguration.getComponents().add(consoleOutputConfiguration);
        topologyConfiguration.addStateFactory(stateFactoryConfiguration);
        topologyConfiguration.getConnections().add(new ConnectionConfiguration(randomWordSourceConfiguration.id, "out", wordCountConfiguration.id, "in"));
        topologyConfiguration.getConnections().add(new ConnectionConfiguration(wordCountConfiguration.id, "out", consoleOutputConfiguration.id, "in"));
        try {
            PythianTopology pythianTopology = new PythianTopology();
            pythianTopology.build(topologyConfiguration);
            cluster.submitTopology(SandBox.class.getSimpleName(), (Map)pythianTopology.getTridentConfig(), pythianTopology.getStormTopology());
            Utils.sleep((long)120000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }

    private static Map<String, String> createMappings(String inside, String outside) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put(inside, outside);
        return mappings;
    }
}

