/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.sandbox;

import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import storm.trident.Stream;
import storm.trident.TridentTopology;
import storm.trident.spout.IBatchSpout;
import storm.trident.testing.FixedBatchSpout;
import stormy.pythian.model.annotation.ComponentType;
import stormy.pythian.model.annotation.Documentation;
import stormy.pythian.model.annotation.ExpectedFeature;
import stormy.pythian.model.annotation.Mapper;
import stormy.pythian.model.annotation.OutputStream;
import stormy.pythian.model.annotation.Topology;
import stormy.pythian.model.component.Component;
import stormy.pythian.model.instance.Instance;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;

@Documentation(name="Random Word Source", description="Emit random string", type=ComponentType.STREAM_SOURCE)
public class RandomWordSource
implements Component {
    private static final long serialVersionUID = 3239910438778205769L;
    public static final String WORD_FEATURE = "word";
    @OutputStream(name="out", newFeatures={@ExpectedFeature(name="word", type=String.class)})
    private Stream out;
    @Mapper(stream="out")
    private OutputFixedFeaturesMapper mapper;
    @Topology
    private TridentTopology topology;

    public void init() {
        FixedBatchSpout spout = new FixedBatchSpout(new Fields(new String[]{"NEW_INSTANCE_FIELD"}), 3, new List[]{this.createValues("jackson"), this.createValues("nathan"), this.createValues("pierre"), this.createValues("nathan"), this.createValues("pierre"), this.createValues("jackson"), this.createValues("nathan"), this.createValues("julie")});
        this.out = this.topology.newStream(RandomStringUtils.randomAlphabetic((int)6), (IBatchSpout)spout);
    }

    private Values createValues(String word) {
        HashMap<String, String> features = new HashMap<String, String>();
        features.put(WORD_FEATURE, word);
        Instance instance = Instance.newInstance((OutputFixedFeaturesMapper)this.mapper, features);
        return new Values(new Object[]{instance});
    }
}

