/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.cluster;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.TopologySummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;
import stormy.pythian.core.topology.PythianTopology;
import stormy.pythian.service.cluster.TopologyKillException;
import stormy.pythian.service.cluster.TopologyLaunchException;
import stormy.pythian.service.cluster.TopologyState;
import stormy.pythian.service.topology.TopologyRepository;

@Service
public class LocalCLusterService {
    @Autowired
    private TopologyRepository topologyRepository;
    private LocalCluster cluster;

    @PostConstruct
    protected void initLocalCluster() {
        this.cluster = new LocalCluster();
    }

    @PreDestroy
    protected void shutdownLocalCluster() {
        this.cluster.shutdown();
    }

    public void launch(String topologyId) throws TopologyLaunchException {
        Config tridentConfig;
        StormTopology stormTopology;
        PythianToplogyConfiguration configuration = this.topologyRepository.findById(topologyId);
        if (configuration == null) {
            throw new TopologyLaunchException("No topology found with id " + topologyId);
        }
        try {
            PythianTopology pythianTopology = new PythianTopology();
            pythianTopology.build(configuration);
            stormTopology = pythianTopology.getStormTopology();
            tridentConfig = pythianTopology.getTridentConfig();
        }
        catch (Exception ex) {
            throw new TopologyLaunchException("Topology could not be builded", ex);
        }
        try {
            this.cluster.submitTopology(topologyId, (Map)tridentConfig, stormTopology);
        }
        catch (Exception ex) {
            throw new TopologyLaunchException("Topology could not be launched", ex);
        }
    }

    public void kill(String topologyId) throws TopologyKillException {
        try {
            this.cluster.killTopology(topologyId);
        }
        catch (Exception ex) {
            throw new TopologyKillException("Topology could not be killed", ex);
        }
    }

    public List<TopologyState> getTopologyStates() {
        List summaries = this.cluster.getClusterInfo().get_topologies();
        ArrayList<TopologyState> states = new ArrayList<TopologyState>(summaries.size());
        for (TopologySummary summary : summaries) {
            PythianToplogyConfiguration topology = this.topologyRepository.findById(summary.get_name());
            if (topology == null) continue;
            states.add(new TopologyState(topology.getId(), topology.getName(), TopologyState.Status.fromStormStatus(summary.get_status())));
        }
        return states;
    }

    public TopologyState getTopologyState(String topologyId) {
        PythianToplogyConfiguration configuration = this.topologyRepository.findById(topologyId);
        List summaries = this.cluster.getClusterInfo().get_topologies();
        for (TopologySummary summary : summaries) {
            if (!StringUtils.equals((String)summary.get_name(), (String)topologyId)) continue;
            return new TopologyState(configuration.getId(), configuration.getName(), TopologyState.Status.fromStormStatus(summary.get_status()));
        }
        return new TopologyState(configuration.getId(), configuration.getName(), TopologyState.Status.UNDEPLOYED);
    }
}

