/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.description;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Repository;
import stormy.pythian.model.component.Component;
import stormy.pythian.model.component.PythianState;

@Repository
public class ClassRepository {
    private static final String STORMY_PYTHIAN_PACKAGE = "stormy.pythian";
    private Reflections reflections;

    @PostConstruct
    public void loadReflections() {
        this.reflections = new Reflections(STORMY_PYTHIAN_PACKAGE, new Scanner[0]);
    }

    public Set<Class<? extends Component>> getComponentClasses() {
        return Sets.filter((Set)this.reflections.getSubTypesOf(Component.class), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !Modifier.isAbstract(input.getModifiers());
            }
        });
    }

    public Set<Class<? extends PythianState>> getStateClasses() {
        return Sets.filter((Set)this.reflections.getSubTypesOf(PythianState.class), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !Modifier.isAbstract(input.getModifiers());
            }
        });
    }
}

