/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.description;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import stormy.pythian.core.description.ComponentDescription;
import stormy.pythian.core.description.ComponentDescriptionFactory;
import stormy.pythian.core.description.PythianStateDescription;
import stormy.pythian.core.description.PythianStateDescriptionFactory;
import stormy.pythian.model.component.Component;
import stormy.pythian.model.component.PythianState;
import stormy.pythian.service.description.ClassRepository;

@Service
public class DescriptionService {
    @Autowired
    private ComponentDescriptionFactory componentDescriptionFactory;
    @Autowired
    private PythianStateDescriptionFactory stateDescriptionFactory;
    @Autowired
    private ClassRepository classRepository;

    public List<ComponentDescription> findAllComponentDescriptions() {
        Set<Class<? extends Component>> classes = this.classRepository.getComponentClasses();
        ArrayList<ComponentDescription> descriptions = new ArrayList<ComponentDescription>();
        for (Class<? extends Component> componentClass : classes) {
            try {
                ComponentDescription description = this.componentDescriptionFactory.createDescription(componentClass);
                descriptions.add(description);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return descriptions;
    }

    public List<PythianStateDescription> findAllStateDescriptions() {
        Set<Class<? extends PythianState>> classes = this.classRepository.getStateClasses();
        ArrayList<PythianStateDescription> descriptions = new ArrayList<PythianStateDescription>();
        for (Class<? extends PythianState> clazz : classes) {
            try {
                PythianStateDescription description = this.stateDescriptionFactory.createDescription(clazz);
                descriptions.add(description);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return descriptions;
    }
}

