/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.spring;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JacksonJsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;
import stormy.pythian.core.ioc.CoreConfiguration;
import stormy.pythian.service.spring.PyhtianProperties;

@Configuration
@ComponentScan(value={"stormy.pythian.service"})
@Import(value={CoreConfiguration.class, PyhtianProperties.class})
public class ServiceConfiguration {
    @Value(value="${redis.hostname}")
    private String redisHostName;
    @Value(value="${redis.password}")
    private String redisPassword;
    @Value(value="${redis.port}")
    private Integer redisPort;

    @Bean
    public RedisTemplate<String, PythianToplogyConfiguration> redisTopologyTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory());
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new JacksonJsonRedisSerializer(PythianToplogyConfiguration.class));
        return template;
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        JedisConnectionFactory connectionFactory = new JedisConnectionFactory();
        connectionFactory.setHostName(this.redisHostName);
        connectionFactory.setPort(this.redisPort.intValue());
        connectionFactory.setPassword(this.redisPassword);
        return connectionFactory;
    }
}

