/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.service.topology;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;
import stormy.pythian.core.configuration.PythianToplogyConfiguration;

@Repository
public class TopologyRepository {
    private static final String TOPOLOGY_RAW_KEY = "pythian-topology";
    @Autowired
    private RedisTemplate<String, PythianToplogyConfiguration> redisTemplate;

    public void save(PythianToplogyConfiguration configuration) {
        this.redisTemplate.opsForHash().put((Object)TOPOLOGY_RAW_KEY, (Object)configuration.getId(), (Object)configuration);
    }

    public void delete(String configurationId) {
        this.redisTemplate.opsForHash().delete((Object)TOPOLOGY_RAW_KEY, new Object[]{configurationId});
    }

    public Collection<PythianToplogyConfiguration> findAll() {
        ArrayList<PythianToplogyConfiguration> topologies = new ArrayList<PythianToplogyConfiguration>();
        for (Object topology : this.redisTemplate.opsForHash().values((Object)TOPOLOGY_RAW_KEY)) {
            topologies.add((PythianToplogyConfiguration)topology);
        }
        return topologies;
    }

    public PythianToplogyConfiguration findById(String configurationId) {
        return (PythianToplogyConfiguration)this.redisTemplate.opsForHash().get((Object)TOPOLOGY_RAW_KEY, (Object)configurationId);
    }
}

