/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.testing;

import backtype.storm.Config;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;
import stormy.pythian.model.instance.Instance;

public class FixedInstanceSpout
implements IBatchSpout {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static Map<String, AtomicInteger> PROCESSED_COUNTS = new HashMap<String, AtomicInteger>();
    private static Map<String, AtomicBoolean> STARTERS = new HashMap<String, AtomicBoolean>();
    private final String uuid;
    private final int instanceCount;
    private final int maxBatchSize;
    private final HashMap<Long, List<List<Object>>> batches = new HashMap();
    private int index = 0;
    private final List<Instance> instances;

    public FixedInstanceSpout(Instance ... instances) {
        this(1000, true, instances);
    }

    public FixedInstanceSpout(boolean autoStart, Instance ... instances) {
        this(1000, autoStart, instances);
    }

    public FixedInstanceSpout(int maxBatchSize, boolean autoStart, Instance ... instances) {
        this.instances = Arrays.asList(instances);
        this.uuid = UUID.randomUUID().toString();
        this.instanceCount = instances.length;
        this.maxBatchSize = maxBatchSize;
        STARTERS.put(this.uuid, new AtomicBoolean(autoStart));
        PROCESSED_COUNTS.put(this.uuid, new AtomicInteger());
    }

    public void start() {
        STARTERS.get(this.uuid).set(true);
    }

    public void ack(long batchId) {
        List<List<Object>> processedInstances = this.batches.remove(batchId);
        if (processedInstances != null && !processedInstances.isEmpty()) {
            for (int i = 0; i < processedInstances.size(); ++i) {
                PROCESSED_COUNTS.get(this.uuid).incrementAndGet();
            }
        }
    }

    public boolean allInstancesProcessed() {
        return PROCESSED_COUNTS.get(this.uuid).get() == this.instanceCount;
    }

    public void open(Map conf, TopologyContext context) {
        this.index = 0;
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        if (STARTERS.get(this.uuid).get()) {
            List<List<Object>> batch = this.batches.get(batchId);
            if (batch == null) {
                batch = new ArrayList<List<Object>>();
                for (int i = 0; this.index < this.instances.size() && i < this.maxBatchSize; ++i) {
                    batch.add((List<Object>)new Values(new Object[]{this.instances.get(this.index)}));
                    ++this.index;
                }
                this.batches.put(batchId, batch);
            }
            for (List<Object> list : batch) {
                collector.emit(list);
            }
        }
    }

    public void close() {
    }

    public Map getComponentConfiguration() {
        Config conf = new Config();
        conf.setMaxTaskParallelism(1);
        return conf;
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{"INSTANCE_FIELD"});
    }
}

