/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf;

import backtype.storm.Config;
import com.github.pmerienne.trident.cf.TridentCollaborativeFiltering;
import com.google.common.base.Preconditions;
import storm.trident.Stream;
import storm.trident.TridentTopology;

public class TridentCollaborativeFilteringBuilder {
    private TridentTopology topology;
    private TridentCollaborativeFiltering.Options options = new TridentCollaborativeFiltering.Options();
    private Config config;
    private Stream preferenceStream;
    private Stream updateSimilaritiesStream;

    public TridentCollaborativeFilteringBuilder use(TridentTopology topology) {
        this.topology = topology;
        return this;
    }

    public TridentCollaborativeFilteringBuilder with(TridentCollaborativeFiltering.Options options) {
        this.options = options;
        return this;
    }

    public TridentCollaborativeFilteringBuilder configure(Config config) {
        this.config = config;
        return this;
    }

    public TridentCollaborativeFilteringBuilder process(Stream preferenceStream) {
        this.preferenceStream = preferenceStream;
        return this;
    }

    public TridentCollaborativeFilteringBuilder updateSimilaritiesOn(Stream updateSimilaritiesStream) {
        this.updateSimilaritiesStream = updateSimilaritiesStream;
        return this;
    }

    public TridentCollaborativeFiltering build() {
        Preconditions.checkArgument((this.topology != null ? 1 : 0) != 0, (Object)"You must provide a TridentTopology");
        Preconditions.checkArgument((this.preferenceStream != null ? 1 : 0) != 0, (Object)"You must provide a stream containing preferences (required fields : 'user','item'))");
        TridentCollaborativeFiltering tridentCollaborativeFiltering = new TridentCollaborativeFiltering(this.topology, this.options);
        tridentCollaborativeFiltering.appendUpdateUserPreferencesTopology(this.preferenceStream);
        if (this.updateSimilaritiesStream != null) {
            tridentCollaborativeFiltering.appendUpdateUserSimilaritiesTopology(this.updateSimilaritiesStream);
        }
        if (this.config != null) {
            tridentCollaborativeFiltering.registerKryoSerializers(this.config);
        }
        return tridentCollaborativeFiltering;
    }
}

