/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.builtin;

import backtype.storm.Config;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class DelayedSimilaritiesUpdateLauncher
implements IBatchSpout {
    private static final long serialVersionUID = -2179825508965427832L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedSimilaritiesUpdateLauncher.class);
    private long delayMs;
    private long startMs;
    private boolean running = false;

    public DelayedSimilaritiesUpdateLauncher(long delayMs) {
        this.delayMs = delayMs;
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        Utils.sleep((long)this.delayMs);
        if (!this.running) {
            this.running = true;
            this.startMs = System.currentTimeMillis();
            LOGGER.info("Full similarities update started");
            collector.emit((List)new Values());
        }
    }

    public void close() {
    }

    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.setMaxTaskParallelism(1);
        return conf;
    }

    public void open(Map conf, TopologyContext context) {
    }

    public void ack(long batchId) {
        long elapsedSeconds = (System.currentTimeMillis() - this.startMs) / 1000L;
        LOGGER.info("Full similarities update finished in " + elapsedSeconds + " seconds");
        this.running = false;
    }

    public Fields getOutputFields() {
        return new Fields(new String[0]);
    }
}

