/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.function;

import backtype.storm.tuple.Values;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;

public class TanimotoCoefficientSimilarity
extends BaseFunction {
    private static final long serialVersionUID = 1014073072262444995L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TanimotoCoefficientSimilarity.class);

    public void execute(TridentTuple tuple, TridentCollector collector) {
        long user1PreferenceCount = tuple.getLong(0);
        long user2PreferenceCount = tuple.getLong(1);
        long coPreferenceCount = tuple.getLong(2);
        double userSimilarity = this.userSimilarity(user1PreferenceCount, user2PreferenceCount, coPreferenceCount);
        collector.emit((List)new Values(new Object[]{userSimilarity}));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tanimoto similarity : " + userSimilarity + " (user1 : " + user1PreferenceCount + ", user2 : " + user2PreferenceCount + ", co : " + coPreferenceCount + ")");
        }
    }

    protected double userSimilarity(long user1PreferenceCount, long user2PreferenceCount, long coPreferenceCount) {
        long unionSize = user1PreferenceCount + user2PreferenceCount - coPreferenceCount;
        double similarity = (double)coPreferenceCount / (double)unionSize;
        return similarity;
    }
}

