/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.function;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.cf.model.RecommendedItem;
import com.github.pmerienne.trident.cf.model.WeightedPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;

public class TopNRecommendedItems
extends BaseFunction {
    private static final long serialVersionUID = 2330321317497348772L;
    private int nbItems;

    public TopNRecommendedItems(int nbItems) {
        this.nbItems = nbItems;
    }

    public void execute(TridentTuple tuple, TridentCollector collector) {
        WeightedPreferences weightedPreferences = (WeightedPreferences)tuple.get(0);
        List<RecommendedItem> itemRecommendations = this.getItemRecommendations(weightedPreferences);
        collector.emit((List)new Values(new Object[]{itemRecommendations}));
    }

    protected List<RecommendedItem> getItemRecommendations(WeightedPreferences weightedPreferences) {
        PriorityQueue topItems = new PriorityQueue(this.nbItems + 1, Collections.reverseOrder());
        boolean full = false;
        double lowestTopValue = Double.NEGATIVE_INFINITY;
        for (Long item : weightedPreferences.getItems()) {
            double recommendation = weightedPreferences.getRecommendation(item);
            if (Double.isNaN(recommendation) || full && !(recommendation > lowestTopValue)) continue;
            topItems.add(new RecommendedItem(item, recommendation));
            if (full) {
                topItems.poll();
            } else if (topItems.size() > this.nbItems) {
                full = true;
                topItems.poll();
            }
            lowestTopValue = ((RecommendedItem)topItems.peek()).getRecommendation();
        }
        int size = topItems.size();
        if (size == 0) {
            return new ArrayList<RecommendedItem>();
        }
        ArrayList<RecommendedItem> sorted = new ArrayList<RecommendedItem>(size);
        sorted.addAll(topItems);
        Collections.sort(sorted);
        return sorted;
    }
}

