/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.model;

import java.io.Serializable;

public class RecommendedItem
implements Comparable<RecommendedItem>,
Serializable {
    private static final long serialVersionUID = -682518328605185319L;
    protected final long item;
    protected final double recommendation;

    public RecommendedItem(long item, double recommendation) {
        this.item = item;
        this.recommendation = recommendation;
    }

    public long getItem() {
        return this.item;
    }

    public double getRecommendation() {
        return this.recommendation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.item ^ this.item >>> 32);
        long temp = Double.doubleToLongBits(this.recommendation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecommendedItem other = (RecommendedItem)obj;
        if (this.item != other.item) {
            return false;
        }
        return Double.doubleToLongBits(this.recommendation) == Double.doubleToLongBits(other.recommendation);
    }

    @Override
    public int compareTo(RecommendedItem other) {
        double otherRecommendation = other.recommendation;
        if (this.recommendation > otherRecommendation) {
            return -1;
        }
        if (this.recommendation < otherRecommendation) {
            return 1;
        }
        long otherItem = other.item;
        if (this.item < otherItem) {
            return -1;
        }
        if (this.item > otherItem) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "RecommendedItem [item=" + this.item + ", recommendation=" + this.recommendation + "]";
    }
}

