/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.model;

import java.io.Serializable;

public class SimilarUser
implements Comparable<SimilarUser>,
Serializable {
    private static final long serialVersionUID = 1808024231838017915L;
    private final long user;
    private final double similarity;

    public SimilarUser(long user, double similarity) {
        this.user = user;
        this.similarity = similarity;
    }

    public long getUser() {
        return this.user;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.similarity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.user ^ this.user >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimilarUser other = (SimilarUser)obj;
        if (Double.doubleToLongBits(this.similarity) != Double.doubleToLongBits(other.similarity)) {
            return false;
        }
        return this.user == other.user;
    }

    @Override
    public int compareTo(SimilarUser other) {
        double otherSimilarity = other.getSimilarity();
        if (this.similarity > otherSimilarity) {
            return -1;
        }
        if (this.similarity < otherSimilarity) {
            return 1;
        }
        long otherUser = other.getUser();
        if (this.user < otherUser) {
            return -1;
        }
        if (this.user > otherUser) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "SimilarUser [user=" + this.user + ", similarity=" + this.similarity + "]";
    }
}

