/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WeightedPreferences
implements Serializable {
    private static final long serialVersionUID = -3814769516554929611L;
    protected Map<Long, Double> preferenceScores;
    protected double scoreSum = 0.0;

    public WeightedPreferences() {
        this(new HashMap<Long, Double>());
    }

    public WeightedPreferences(Map<Long, Double> preferenceScores) {
        this.preferenceScores = preferenceScores;
    }

    public WeightedPreferences(Map<Long, Double> preferenceScores, double scoreSum) {
        this.preferenceScores = preferenceScores;
        this.scoreSum = scoreSum;
    }

    public void addAll(Set<Long> items, double similarity) {
        for (long item : items) {
            this.add(item, similarity);
        }
    }

    public void add(long item, double similarity) {
        this.scoreSum += similarity;
        Double actualScore = this.preferenceScores.get(item);
        if (actualScore == null) {
            actualScore = 0.0;
        }
        this.preferenceScores.put(item, actualScore + similarity);
    }

    public Set<Long> getItems() {
        return this.preferenceScores.keySet();
    }

    public Double getRecommendation(long item) {
        Double actualScore = this.preferenceScores.get(item);
        if (actualScore == null) {
            actualScore = 0.0;
        }
        return this.scoreSum == 0.0 ? 0.0 : actualScore / this.scoreSum;
    }

    public static WeightedPreferences combine(WeightedPreferences val1, WeightedPreferences val2) {
        WeightedPreferences newWeightedPreferences = new WeightedPreferences(val1.preferenceScores, val1.scoreSum);
        for (Map.Entry<Long, Double> otherScore : val2.preferenceScores.entrySet()) {
            newWeightedPreferences.add(otherScore.getKey(), otherScore.getValue());
        }
        return newWeightedPreferences;
    }
}

