/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state;

import java.util.List;
import storm.trident.state.State;

public interface SortedSetMultiMapState<K, T>
extends State {
    public long sizeOf(K var1);

    public boolean put(K var1, ScoredValue<T> var2);

    public List<ScoredValue<T>> getSorted(K var1, int var2);

    public double getScore(K var1, T var2);

    public static class ScoredValue<T>
    implements Comparable<ScoredValue<T>> {
        private final double score;
        private final T value;

        public ScoredValue(double score, T value) {
            this.score = score;
            this.value = value;
        }

        public double getScore() {
            return this.score;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ScoredValue<T> o) {
            if (o == null) {
                return 1;
            }
            if (this.score != o.score) {
                return Double.compare(this.score, o.score);
            }
            return ScoredValue.compare(o.getValue(), o.getValue());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScoredValue other = (ScoredValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "ScoredValue [score=" + this.score + ", value=" + this.value + "]";
        }

        public static <T> int compare(T k1, T k2) {
            if (k1 instanceof Comparable) {
                return ((Comparable)k1).compareTo(k2);
            }
            return 0;
        }
    }
}

