/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.cf.state.SetState;
import com.github.pmerienne.trident.cf.state.memory.TransactionalMemoryMapState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class MemorySetState<T>
extends TransactionalMemoryMapState<Set<T>>
implements SetState<T> {
    public MemorySetState(String id) {
        super(id);
    }

    @Override
    public Set<T> get() {
        HashSet set = (HashSet)super.get();
        if (set == null) {
            set = new HashSet();
        }
        return set;
    }

    @Override
    public boolean add(T e) {
        Object set = this.get();
        boolean result = set.add(e);
        this.set(set);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object set = this.get();
        boolean result = set.addAll(c);
        this.set(set);
        return result;
    }

    @Override
    public void clear() {
        this.set(new HashSet());
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = -6865870100536320916L;
        private final String _id = UUID.randomUUID().toString();

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemorySetState(this._id);
        }
    }
}

