/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.cf.state.SortedSetMultiMapState;
import com.github.pmerienne.trident.cf.state.memory.TransactionalMemoryMapState;
import com.github.pmerienne.trident.cf.util.MapStateUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class MemorySortedSetMultiMapState<K, T>
extends TransactionalMemoryMapState<TreeSet<SortedSetMultiMapState.ScoredValue<T>>>
implements SortedSetMultiMapState<K, T> {
    public MemorySortedSetMultiMapState(String id) {
        super(id);
    }

    @Override
    public long sizeOf(K key) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        return set == null ? 0L : (long)set.size();
    }

    @Override
    public boolean put(K key, SortedSetMultiMapState.ScoredValue<T> scoredValue) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        boolean result = set.add(scoredValue);
        MapStateUtil.putSingle(this, key, set);
        return result;
    }

    @Override
    public List<SortedSetMultiMapState.ScoredValue<T>> getSorted(K key, int count) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        ArrayList<SortedSetMultiMapState.ScoredValue<T>> results = new ArrayList<SortedSetMultiMapState.ScoredValue<T>>(count);
        int i = 0;
        Iterator<SortedSetMultiMapState.ScoredValue<T>> it = set.descendingIterator();
        while (it.hasNext() && i < count) {
            results.add(it.next());
        }
        return results;
    }

    @Override
    public double getScore(K key, T value) {
        TreeSet<SortedSetMultiMapState.ScoredValue<T>> set = this.get(key);
        if (set == null) {
            return 0.0;
        }
        Double score = null;
        Iterator<SortedSetMultiMapState.ScoredValue<T>> it = set.iterator();
        while (it.hasNext() && score == null) {
            SortedSetMultiMapState.ScoredValue<T> current = it.next();
            if (!current.getValue().equals(value)) continue;
            score = current.getScore();
        }
        return score == null ? 0.0 : score;
    }

    protected TreeSet<SortedSetMultiMapState.ScoredValue<T>> get(K key) {
        TreeSet value = (TreeSet)MapStateUtil.getSingle(this, key);
        if (value == null) {
            value = new TreeSet();
        }
        return value;
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = -6865870100536320916L;
        private final String _id = UUID.randomUUID().toString();

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemorySortedSetMultiMapState(this._id);
        }
    }
}

