/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.memory;

import backtype.storm.task.IMetricsContext;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import storm.trident.state.ITupleCollection;
import storm.trident.state.State;
import storm.trident.state.StateFactory;
import storm.trident.state.TransactionalValue;
import storm.trident.state.ValueUpdater;
import storm.trident.state.map.IBackingMap;
import storm.trident.state.map.MapState;
import storm.trident.state.map.SnapshottableMap;
import storm.trident.state.map.TransactionalMap;
import storm.trident.state.snapshot.Snapshottable;

public class TransactionalMemoryMapState<T>
implements Snapshottable<T>,
ITupleCollection,
MapState<T> {
    MemoryMapStateBacking<TransactionalValue> _backing;
    SnapshottableMap<T> _delegate;
    static ConcurrentHashMap<String, Map<List<Object>, Object>> _dbs = new ConcurrentHashMap();

    public TransactionalMemoryMapState(String id) {
        this._backing = new MemoryMapStateBacking(id);
        this._delegate = new SnapshottableMap(TransactionalMap.build(this._backing), (List)new Values(new Object[]{"$MEMORY-MAP-STATE-GLOBAL$"}));
    }

    public T update(ValueUpdater updater) {
        return (T)this._delegate.update(updater);
    }

    public void set(T o) {
        this._delegate.set(o);
    }

    public T get() {
        return (T)this._delegate.get();
    }

    public void beginCommit(Long txid) {
        this._delegate.beginCommit(txid);
    }

    public void commit(Long txid) {
        this._delegate.commit(txid);
    }

    public Iterator<List<Object>> getTuples() {
        return this._backing.getTuples();
    }

    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        return this._delegate.multiUpdate(keys, updaters);
    }

    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this._delegate.multiPut(keys, vals);
    }

    public List<T> multiGet(List<List<Object>> keys) {
        return this._delegate.multiGet(keys);
    }

    public static class MemoryMapStateBacking<T>
    implements IBackingMap<T>,
    ITupleCollection {
        Map<List<Object>, T> db;
        Long currTx;

        public static void clearAll() {
            _dbs.clear();
        }

        public MemoryMapStateBacking(String id) {
            if (!_dbs.containsKey(id)) {
                _dbs.put(id, new HashMap());
            }
            this.db = _dbs.get(id);
        }

        public List<T> multiGet(List<List<Object>> keys) {
            ArrayList<T> ret = new ArrayList<T>();
            for (List<Object> key : keys) {
                ret.add(this.db.get(key));
            }
            return ret;
        }

        public void multiPut(List<List<Object>> keys, List<T> vals) {
            for (int i = 0; i < keys.size(); ++i) {
                List<Object> key = keys.get(i);
                T val = vals.get(i);
                this.db.put(key, val);
            }
        }

        public Iterator<List<Object>> getTuples() {
            return new Iterator<List<Object>>(){
                private Iterator<Map.Entry<List<Object>, T>> it;
                {
                    this.it = MemoryMapStateBacking.this.db.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public List<Object> next() {
                    Map.Entry e = this.it.next();
                    ArrayList<Object> ret = new ArrayList<Object>();
                    ret.addAll((Collection)e.getKey());
                    ret.add(((TransactionalValue)e.getValue()).getVal());
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    public static class Factory
    implements StateFactory {
        String _id = UUID.randomUUID().toString();

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new TransactionalMemoryMapState(this._id);
        }
    }
}

