/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.query;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.cf.model.UserPair;
import com.github.pmerienne.trident.cf.state.SetState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.tuple.TridentTuple;

public class AllUserPairQuery
extends BaseQueryFunction<SetState<Long>, Set<UserPair>> {
    private static final long serialVersionUID = -7677538937604670988L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AllUserPairQuery.class);

    public List<Set<UserPair>> batchRetrieve(SetState<Long> state, List<TridentTuple> args) {
        int i;
        Set<Long> allUsers = state.get();
        int nbUsers = allUsers.size();
        int userPairsSize = nbUsers * nbUsers / 2;
        ArrayList<Set<UserPair>> results = new ArrayList<Set<UserPair>>(args.size());
        HashSet<UserPair> userPairs = new HashSet<UserPair>(userPairsSize);
        LOGGER.info(nbUsers + " users found. " + userPairsSize + " similarities will be updated");
        long[] usersArray = new long[nbUsers];
        int k = 0;
        Iterator<Long> i$ = allUsers.iterator();
        while (i$.hasNext()) {
            long user;
            usersArray[k] = user = i$.next().longValue();
            ++k;
        }
        for (i = 0; i < nbUsers; ++i) {
            for (int j = i + 1; j < nbUsers; ++j) {
                userPairs.add(new UserPair(usersArray[i], usersArray[j]));
            }
        }
        for (i = 0; i < args.size(); ++i) {
            results.add(userPairs);
        }
        return results;
    }

    public void execute(TridentTuple tuple, Set<UserPair> result, TridentCollector collector) {
        for (UserPair userPair : result) {
            collector.emit((List)new Values(new Object[]{userPair.getUser1(), userPair.getUser2()}));
        }
    }
}

