/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.query;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.cf.model.SimilarUser;
import com.github.pmerienne.trident.cf.state.SortedSetMultiMapState;
import java.util.ArrayList;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.tuple.TridentTuple;

public class SimilarUsersQuery
extends BaseQueryFunction<SortedSetMultiMapState<Long, Long>, List<SimilarUser>> {
    private static final long serialVersionUID = -8188458622514047837L;
    public static final int DEFAULT_COUNT = 10;
    private int count = 10;

    public SimilarUsersQuery() {
    }

    public SimilarUsersQuery(int count) {
        this.count = count;
    }

    public List<List<SimilarUser>> batchRetrieve(SortedSetMultiMapState<Long, Long> state, List<TridentTuple> args) {
        ArrayList<List<SimilarUser>> results = new ArrayList<List<SimilarUser>>(args.size());
        for (TridentTuple tuple : args) {
            long user1 = tuple.getLong(0);
            List<SortedSetMultiMapState.ScoredValue<Long>> scoredValues = state.getSorted(user1, this.count);
            results.add(this.toSimilarUsers(scoredValues));
        }
        return results;
    }

    public void execute(TridentTuple tuple, List<SimilarUser> similarUsers, TridentCollector collector) {
        long user1 = tuple.getLong(0);
        for (SimilarUser similarUser : similarUsers) {
            if (similarUser.getUser() == user1) continue;
            collector.emit((List)new Values(new Object[]{similarUser.getUser(), similarUser.getSimilarity()}));
        }
    }

    protected List<SimilarUser> toSimilarUsers(List<SortedSetMultiMapState.ScoredValue<Long>> scoredValues) {
        ArrayList<SimilarUser> similarUsers = new ArrayList<SimilarUser>(scoredValues.size());
        for (SortedSetMultiMapState.ScoredValue<Long> scoredValue : scoredValues) {
            similarUsers.add(new SimilarUser(scoredValue.getValue(), scoredValue.getScore()));
        }
        return similarUsers;
    }
}

