/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.query;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.cf.state.MapMultimapState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.tuple.TridentTuple;

public class UsersWithCoPreferenceCountQuery
extends BaseQueryFunction<MapMultimapState<Long, Long, Long>, Map<Long, Long>> {
    private static final long serialVersionUID = 3700955398704099456L;

    public List<Map<Long, Long>> batchRetrieve(MapMultimapState<Long, Long, Long> state, List<TridentTuple> tuples) {
        ArrayList<Map<Long, Long>> results = new ArrayList<Map<Long, Long>>();
        for (TridentTuple tuple : tuples) {
            long user = tuple.getLong(0);
            Map<Long, Long> usersWithCoPreferenceCount = state.getAll(user);
            results.add(usersWithCoPreferenceCount);
        }
        return results;
    }

    public void execute(TridentTuple tuple, Map<Long, Long> usersWithCoPreferenceCount, TridentCollector collector) {
        for (long user : usersWithCoPreferenceCount.keySet()) {
            long coPreferenceCount = usersWithCoPreferenceCount.get(user);
            collector.emit((List)new Values(new Object[]{user, coPreferenceCount}));
        }
    }
}

