/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.redis;

import com.github.pmerienne.trident.cf.state.redis.KryoValueSerializer;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import storm.trident.state.Serializer;
import storm.trident.state.State;

public abstract class AbstractRedisState
implements State {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    public static final String REDIS_HOST_CONF = "redis.port";
    public static final String REDIS_PORT_CONF = "redis.host";
    private static final String KEY_PREFIX = "cf";
    private static final String KEY_SEPARATOR = ":";
    protected String id;
    protected String host;
    protected int port;
    protected JedisPool pool;
    protected Serializer<Object> serializer = new KryoValueSerializer();

    public AbstractRedisState(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.pool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), this.host, this.port, 2000, null, 0);
    }

    public AbstractRedisState(String id) {
        this(id, DEFAULT_HOST, 6379);
    }

    protected String generateKey() {
        StringBuilder sb = new StringBuilder(KEY_PREFIX).append(KEY_SEPARATOR).append(this.id);
        return sb.toString();
    }

    protected String generateKey(Object key) {
        StringBuilder sb = new StringBuilder(KEY_PREFIX).append(KEY_SEPARATOR).append(this.id).append(KEY_SEPARATOR).append(key.toString());
        return sb.toString();
    }

    protected String generateKey(List<Object> keys) {
        StringBuilder sb = new StringBuilder(KEY_PREFIX).append(KEY_SEPARATOR).append(this.id);
        for (Object key : keys) {
            sb.append(KEY_SEPARATOR).append(key.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.flushDB();
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    protected static String getHost(Map conf) {
        Object value = conf.get(REDIS_HOST_CONF);
        return value == null || !(value instanceof String) ? null : (String)value;
    }

    protected static Integer getPort(Map conf) {
        Object value = conf.get(REDIS_PORT_CONF);
        return value == null || !(value instanceof Integer) ? null : (Integer)value;
    }
}

