/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.redis;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.pmerienne.trident.cf.util.StringHexUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import storm.trident.state.Serializer;

public class KryoValueSerializer
implements Serializer<Object> {
    private static final long serialVersionUID = 1689053104987281146L;
    private Kryo kryo = new Kryo();

    public byte[] serialize(Object obj) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)stream);
        this.kryo.writeClassAndObject(output, obj);
        output.close();
        byte[] buffer = stream.toByteArray();
        String data = StringHexUtil.toHexString(buffer);
        return data.getBytes();
    }

    public Object deserialize(byte[] bytes) {
        String data = new String(bytes);
        bytes = StringHexUtil.fromHexString(data);
        Input input = new Input(bytes);
        Object obj = this.kryo.readClassAndObject(input);
        return obj;
    }
}

