/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.cf.state.SetMultiMapState;
import com.github.pmerienne.trident.cf.state.redis.AbstractRedisState;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class RedisSetMultiMapState<K, V>
extends AbstractRedisState
implements SetMultiMapState<K, V> {
    public RedisSetMultiMapState(String id) {
        super(id);
    }

    public RedisSetMultiMapState(String id, String host, int port) {
        super(id, host, port);
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeOf(K key) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            result = jedis.scard(stringKey);
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            result = jedis.sadd(stringKey, new String[]{new String(this.serializer.serialize(value))});
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> get(K key) {
        HashSet<Object> results = new HashSet<Object>();
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            Set resultsAsString = jedis.smembers(stringKey);
            for (String result : resultsAsString) {
                if (result == null || result.isEmpty()) {
                    results.add(null);
                    continue;
                }
                results.add(this.serializer.deserialize(result.getBytes()));
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return results;
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = 4718043951532492603L;
        private String id;

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            String host = AbstractRedisState.getHost(conf);
            Integer port = AbstractRedisState.getPort(conf);
            RedisSetMultiMapState state = host != null && port != null ? new RedisSetMultiMapState(this.id, host, port) : new RedisSetMultiMapState(this.id);
            return state;
        }
    }
}

