/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.cf.state.SetState;
import com.github.pmerienne.trident.cf.state.redis.AbstractRedisState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class RedisSetState<T>
extends AbstractRedisState
implements SetState<T> {
    public RedisSetState(String id) {
        super(id);
    }

    public RedisSetState(String id, String host, int port) {
        super(id, host, port);
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T e) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String key = this.generateKey();
            result = jedis.sadd(key, new String[]{new String(this.serializer.serialize(e))});
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        String key = this.generateKey();
        String[] members = new String[c.size()];
        int i = 0;
        for (T element : c) {
            members[i] = new String(this.serializer.serialize(element));
            ++i;
        }
        try {
            result = jedis.sadd(key, members);
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> get() {
        HashSet<Object> results = new HashSet<Object>();
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String key = this.generateKey();
            Set resultsAsString = jedis.smembers(key);
            for (String result : resultsAsString) {
                if (result == null || result.isEmpty()) {
                    results.add(null);
                    continue;
                }
                results.add(this.serializer.deserialize(result.getBytes()));
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String key = this.generateKey();
            jedis.del(new String[]{key});
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = 4718043951532492603L;
        private String id;

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            String host = AbstractRedisState.getHost(conf);
            Integer port = AbstractRedisState.getPort(conf);
            RedisSetState state = host != null && port != null ? new RedisSetState(this.id, host, port) : new RedisSetState(this.id);
            return state;
        }
    }
}

