/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.redis;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.cf.state.SortedSetMultiMapState;
import com.github.pmerienne.trident.cf.state.redis.AbstractRedisState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class RedisSortedSetMultiMapState<K, V>
extends AbstractRedisState
implements SortedSetMultiMapState<K, V> {
    public RedisSortedSetMultiMapState(String id) {
        super(id);
    }

    public RedisSortedSetMultiMapState(String id, String host, int port) {
        super(id, host, port);
    }

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeOf(K key) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            result = jedis.zcard(stringKey);
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, SortedSetMultiMapState.ScoredValue<V> value) {
        long result;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            result = jedis.zadd(stringKey, value.getScore(), new String(this.serializer.serialize(value.getValue())));
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return result == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SortedSetMultiMapState.ScoredValue<V>> getSorted(K key, int count) {
        ArrayList<SortedSetMultiMapState.ScoredValue<V>> scoredValues = new ArrayList<SortedSetMultiMapState.ScoredValue<V>>();
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            Set results = jedis.zrevrangeWithScores(stringKey, 0L, (long)(count - 1));
            for (Tuple result : results) {
                scoredValues.add(new SortedSetMultiMapState.ScoredValue<Object>(result.getScore(), this.serializer.deserialize(result.getBinaryElement())));
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return scoredValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getScore(K key, V value) {
        Double score;
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            String stringKey = this.generateKey(key);
            score = jedis.zscore(stringKey, new String(this.serializer.serialize(value)));
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
        return score == null ? 0.0 : score;
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = 4718043951532492603L;
        private String id;

        public Factory(String id) {
            this.id = id;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            String host = AbstractRedisState.getHost(conf);
            Integer port = AbstractRedisState.getPort(conf);
            RedisSortedSetMultiMapState state = host != null && port != null ? new RedisSortedSetMultiMapState(this.id, host, port) : new RedisSortedSetMultiMapState(this.id);
            return state;
        }
    }
}

