/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.updater;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.cf.model.UserPair;
import com.github.pmerienne.trident.cf.state.MapMultimapState;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.tuple.TridentTuple;

public class CoPreferenceCountUpdater
extends BaseStateUpdater<MapMultimapState<Long, Long, Long>> {
    private static final long serialVersionUID = -4573528570416406157L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CoPreferenceCountUpdater.class);

    public void updateState(MapMultimapState<Long, Long, Long> state, List<TridentTuple> tuples, TridentCollector collector) {
        for (TridentTuple tuple : tuples) {
            UserPair userPair = (UserPair)tuple.get(0);
            long user1 = userPair.getUser1();
            long user2 = userPair.getUser2();
            Long count = state.get(user1, user2);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            state.put(user1, user2, count);
            state.put(user2, user1, count);
            collector.emit((List)new Values(new Object[]{userPair, count}));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Increment co preference count between " + user1 + " and " + user2 + " to " + count);
        }
    }
}

