/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.cf.state.updater;

import com.github.pmerienne.trident.cf.state.SortedSetMultiMapState;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.tuple.TridentTuple;

public class UserSimilarityUpdater
extends BaseStateUpdater<SortedSetMultiMapState<Long, Long>> {
    private static final long serialVersionUID = -5176326639509447054L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSimilarityUpdater.class);

    public void updateState(SortedSetMultiMapState<Long, Long> state, List<TridentTuple> tuples, TridentCollector collector) {
        for (TridentTuple tuple : tuples) {
            long user1 = tuple.getLong(0);
            long user2 = tuple.getLong(1);
            double similarity = tuple.getDouble(2);
            state.put(user1, new SortedSetMultiMapState.ScoredValue<Long>(similarity, user2));
            state.put(user2, new SortedSetMultiMapState.ScoredValue<Long>(similarity, user2));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Update similarity between " + user1 + " and " + user2 + " to " + similarity);
        }
    }
}

