/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.memory;

import backtype.storm.task.IMetricsContext;
import com.github.pmerienne.trident.state.SetMultiMapState;
import com.github.pmerienne.trident.state.memory.TransactionalMemoryMapState;
import com.github.pmerienne.trident.state.util.MapStateUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import storm.trident.state.State;
import storm.trident.state.StateFactory;

public class MemorySetMultiMapState<K, V>
extends TransactionalMemoryMapState<Set<V>>
implements SetMultiMapState<K, V> {
    public MemorySetMultiMapState(String id) {
        super(id);
    }

    @Override
    public long sizeOf(K key) {
        Set<V> set = this.get(key);
        return set == null ? 0L : (long)set.size();
    }

    @Override
    public Set<V> get(K key) {
        HashSet value = (HashSet)MapStateUtil.getSingle(this, key);
        if (value == null) {
            value = new HashSet();
        }
        return value;
    }

    @Override
    public boolean put(K key, V value) {
        Set<V> set = this.get(key);
        if (set == null) {
            set = new HashSet<V>();
        }
        boolean result = set.add(value);
        MapStateUtil.putSingle(this, key, set);
        return result;
    }

    public static class Factory
    implements StateFactory {
        private static final long serialVersionUID = -6865870100536320916L;
        private final String id = UUID.randomUUID().toString();

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new MemorySetMultiMapState(this.id);
        }
    }
}

