/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.state.redis;

import com.github.pmerienne.trident.state.ExtendedState;
import com.github.pmerienne.trident.state.redis.RedisConfig;
import java.util.List;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import storm.trident.state.Serializer;

public abstract class AbstractRedisState<T>
implements ExtendedState<T> {
    protected final String id;
    protected final RedisConfig config;
    protected final JedisPool pool;
    protected final Serializer<T> serializer;

    public AbstractRedisState(String id, RedisConfig config) {
        this.id = id;
        this.config = config;
        this.pool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), config.getHost(), config.getPort().intValue(), config.getTimeout().intValue(), null, config.getDatabase().intValue());
        this.serializer = config.getSerializer();
    }

    public AbstractRedisState(String id) {
        this(id, new RedisConfig());
    }

    protected String generateKey() {
        StringBuilder sb = new StringBuilder(this.config.getKeyPrefix()).append(this.config.getKeySeparator()).append(this.id);
        return sb.toString();
    }

    protected String generateKey(Object key) {
        StringBuilder sb = new StringBuilder(this.config.getKeyPrefix()).append(this.config.getKeySeparator()).append(this.id).append(this.config.getKeySeparator()).append(key.toString());
        return sb.toString();
    }

    protected String generateKey(List<Object> keys) {
        StringBuilder sb = new StringBuilder(this.config.getKeyPrefix()).append(this.config.getKeySeparator()).append(this.id);
        for (Object key : keys) {
            sb.append(this.config.getKeySeparator()).append(key.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.flushDB();
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }
}

