/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.classification;

import com.github.pmerienne.trident.ml.classification.Classifier;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.Arrays;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class ClassifierUpdater<L>
extends BaseStateUpdater<MapState<Classifier<L>>> {
    private static final long serialVersionUID = 1943890181994862536L;
    private String classifierName;
    private Classifier<L> initialClassifier;

    public ClassifierUpdater(String classifierName, Classifier<L> initialClassifier) {
        this.classifierName = classifierName;
        this.initialClassifier = initialClassifier;
    }

    public void updateState(MapState<Classifier<L>> state, List<TridentTuple> tuples, TridentCollector collector) {
        List classifiers = state.multiGet(KeysUtil.toKeys(this.classifierName));
        Classifier classifier = null;
        if (classifiers != null && !classifiers.isEmpty()) {
            classifier = (Classifier)classifiers.get(0);
        }
        if (classifier == null) {
            classifier = this.initialClassifier;
        }
        for (TridentTuple tuple : tuples) {
            Instance instance = (Instance)tuple.get(0);
            classifier.update(instance.label, instance.features);
        }
        state.multiPut(KeysUtil.toKeys(this.classifierName), Arrays.asList(classifier));
    }
}

