/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.nlp;

import com.github.pmerienne.trident.ml.core.TextInstance;
import com.github.pmerienne.trident.ml.nlp.TextClassifier;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.Arrays;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseStateUpdater;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class TextClassifierUpdater<L>
extends BaseStateUpdater<MapState<TextClassifier<L>>> {
    private static final long serialVersionUID = 1943890181994862536L;
    private String classifierName;
    private TextClassifier<L> initialClassifier;

    public TextClassifierUpdater(String classifierName, TextClassifier<L> initialClassifier) {
        this.classifierName = classifierName;
        this.initialClassifier = initialClassifier;
    }

    public void updateState(MapState<TextClassifier<L>> state, List<TridentTuple> tuples, TridentCollector collector) {
        List classifiers = state.multiGet(KeysUtil.toKeys(this.classifierName));
        TextClassifier classifier = null;
        if (classifiers != null && !classifiers.isEmpty()) {
            classifier = (TextClassifier)classifiers.get(0);
        }
        if (classifier == null) {
            classifier = this.initialClassifier;
        }
        for (TridentTuple tuple : tuples) {
            TextInstance instance = (TextInstance)tuple.get(0);
            classifier.update(instance.label, instance.tokens);
        }
        state.multiPut(KeysUtil.toKeys(this.classifierName), Arrays.asList(classifier));
    }
}

