/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.testing;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import com.google.common.base.Function;
import java.util.List;
import java.util.Map;
import java.util.Random;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class RandomFeaturesSpout
implements IBatchSpout {
    private static final long serialVersionUID = -5293861317274377258L;
    private int maxBatchSize = 10;
    private int featureSize = 2;
    private double variance = 3.0;
    private boolean withLabel = true;
    private static final Function<double[], Boolean> FEATURES_TO_LABEL = new Function<double[], Boolean>(){

        public Boolean apply(double[] input) {
            double sum = 0.0;
            for (int i = 0; i < input.length; ++i) {
                sum += input[i];
            }
            return sum > 0.0;
        }
    };
    private Random random = new Random();

    public RandomFeaturesSpout() {
    }

    public RandomFeaturesSpout(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public RandomFeaturesSpout(int featureSize, double variance) {
        this.featureSize = featureSize;
        this.variance = variance;
    }

    public RandomFeaturesSpout(boolean withLabel, int featureSize, double variance) {
        this.withLabel = withLabel;
        this.featureSize = featureSize;
        this.variance = variance;
    }

    public void open(Map conf, TopologyContext context) {
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        for (int i = 0; i < this.maxBatchSize; ++i) {
            Values values = new Values();
            double[] features = new double[this.featureSize];
            for (int j = 0; j < this.featureSize; ++j) {
                features[j] = (double)j + this.random.nextGaussian() * this.variance;
            }
            if (this.withLabel) {
                values.add(FEATURES_TO_LABEL.apply((Object)features));
            }
            for (double feature : features) {
                values.add((Object)feature);
            }
            collector.emit((List)values);
        }
    }

    public void ack(long batchId) {
    }

    public void close() {
    }

    public Map getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        String[] fieldNames;
        if (this.withLabel) {
            fieldNames = new String[this.featureSize + 1];
            fieldNames[0] = "label";
            for (int i = 0; i < this.featureSize; ++i) {
                fieldNames[i + 1] = "x" + i;
            }
        } else {
            fieldNames = new String[this.featureSize];
            for (int i = 0; i < this.featureSize; ++i) {
                fieldNames[i] = "x" + i;
            }
        }
        return new Fields(fieldNames);
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getFeatureSize() {
        return this.featureSize;
    }

    public void setFeatureSize(int featureSize) {
        this.featureSize = featureSize;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public boolean isWithLabel() {
        return this.withLabel;
    }

    public void setWithLabel(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

