/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.testing;

import backtype.storm.tuple.Fields;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.testing.FixedBatchSpout;

public class ReutersBatchSpout
extends FixedBatchSpout {
    private static final long serialVersionUID = 2484759216530963284L;
    private static final File REUTEURS_FILE = new File("src/test/resources/reuters.csv");
    private static final List<List<Object>> REUTEURS_TRAINING_SAMPLES = new ArrayList<List<Object>>();
    public static final Map<Integer, String> REUTEURS_EVAL_SAMPLES = new HashMap<Integer, String>();

    public ReutersBatchSpout() {
        super(new Fields(new String[]{"label", "text"}), 300, REUTEURS_TRAINING_SAMPLES.toArray(new List[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadReutersData() throws IOException {
        HashMap<String, Integer> topics = new HashMap<String, Integer>();
        FileInputStream is = new FileInputStream(REUTEURS_FILE);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    String topic = line.split(",")[0];
                    if (!topics.containsKey(topic)) {
                        topics.put(topic, topics.size());
                    }
                    Integer classIndex = (Integer)topics.get(topic);
                    int startIndex = line.indexOf(" - ");
                    String text = line.substring(startIndex, line.length() - 1);
                    if (REUTEURS_EVAL_SAMPLES.containsKey(classIndex)) {
                        REUTEURS_TRAINING_SAMPLES.add(Arrays.asList(classIndex, text));
                        continue;
                    }
                    REUTEURS_EVAL_SAMPLES.put(classIndex, text);
                }
                catch (Exception ex) {
                    System.err.println("Skipped Reuters sample because it can't be parsed : " + line);
                }
            }
            Collections.shuffle(REUTEURS_TRAINING_SAMPLES);
            return;
        }
        finally {
            is.close();
            br.close();
        }
    }

    static {
        try {
            ReutersBatchSpout.loadReutersData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

