/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.classification;

import com.github.pmerienne.trident.ml.classification.Classifier;
import com.github.pmerienne.trident.ml.util.MathUtil;

public class BWinnowClassifier
implements Classifier<Boolean> {
    private static final long serialVersionUID = -5163481593640555140L;
    private double[] u;
    private double[] v;
    private double promotion = 1.5;
    private double demotion = 0.5;
    private double threshold = 1.0;

    public BWinnowClassifier() {
    }

    public BWinnowClassifier(double promotion, double demotion, double threshold) {
        this.promotion = promotion;
        this.demotion = demotion;
        this.threshold = threshold;
    }

    @Override
    public Boolean classify(double[] features) {
        Double evaluation;
        if (this.u == null || this.v == null) {
            this.init(features.length);
        }
        Boolean prediction = (evaluation = Double.valueOf(MathUtil.dot(features, this.u) - MathUtil.dot(features, this.v) - this.threshold)) >= 0.0 ? Boolean.TRUE : Boolean.FALSE;
        return prediction;
    }

    @Override
    public void update(Boolean label, double[] features) {
        Boolean predictedLabel = this.classify(features);
        if (!label.equals(predictedLabel)) {
            for (int i = 0; i < features.length; ++i) {
                if (!(features[i] > 0.0)) continue;
                if (predictedLabel.booleanValue()) {
                    this.u[i] = this.u[i] * this.demotion;
                    this.v[i] = this.v[i] * this.promotion;
                    continue;
                }
                this.u[i] = this.u[i] * this.promotion;
                this.v[i] = this.v[i] * this.demotion;
            }
        }
    }

    protected void init(int featureSize) {
        this.u = new double[featureSize];
        this.v = new double[featureSize];
        for (int i = 0; i < featureSize; ++i) {
            this.u[i] = 2.0 * this.threshold / (double)featureSize;
            this.v[i] = this.threshold / (double)featureSize;
        }
    }

    @Override
    public void reset() {
        this.u = null;
        this.v = null;
    }

    public double[] getU() {
        return this.u;
    }

    public void setU(double[] u) {
        this.u = u;
    }

    public double[] getV() {
        return this.v;
    }

    public void setV(double[] v) {
        this.v = v;
    }

    public double getPromotion() {
        return this.promotion;
    }

    public void setPromotion(double promotion) {
        this.promotion = promotion;
    }

    public double getDemotion() {
        return this.demotion;
    }

    public void setDemotion(double demotion) {
        this.demotion = demotion;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public String toString() {
        return "BWinnowClassifier [promotion=" + this.promotion + ", demotion=" + this.demotion + ", threshold=" + this.threshold + "]";
    }
}

