/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.preprocessing;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.TextInstance;
import com.github.pmerienne.trident.ml.preprocessing.EnglishTokenizer;
import com.github.pmerienne.trident.ml.preprocessing.TextTokenizer;
import java.util.List;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;

public class TextInstanceCreator<L>
extends BaseFunction {
    private static final long serialVersionUID = 3312351524410720639L;
    private boolean withLabel = true;
    private TextTokenizer textAnalyser = new EnglishTokenizer();

    public TextInstanceCreator() {
    }

    public TextInstanceCreator(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public TextInstanceCreator(boolean withLabel, TextTokenizer textAnalyser) {
        this.withLabel = withLabel;
        this.textAnalyser = textAnalyser;
    }

    public void execute(TridentTuple tuple, TridentCollector collector) {
        TextInstance<L> instance = this.createInstance(tuple);
        collector.emit((List)new Values(new Object[]{instance}));
    }

    protected TextInstance<L> createInstance(TridentTuple tuple) {
        Object label = this.withLabel ? tuple.get(0) : null;
        String text = tuple.getString(this.withLabel ? 1 : 0);
        List<String> tokens = this.extractTokens(text);
        TextInstance<Object> instance = new TextInstance<Object>(label, tokens);
        return instance;
    }

    protected List<String> extractTokens(String text) {
        List<String> tokens = this.textAnalyser.tokenize(text);
        return tokens;
    }

    public boolean isWithLabel() {
        return this.withLabel;
    }

    public void setWithLabel(boolean withLabel) {
        this.withLabel = withLabel;
    }

    public TextTokenizer getTextAnalyser() {
        return this.textAnalyser;
    }

    public void setTextAnalyser(TextTokenizer textAnalyser) {
        this.textAnalyser = textAnalyser;
    }
}

