/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.regression;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.regression.Regressor;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.ArrayList;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class RegressionQuery
extends BaseQueryFunction<MapState<Regressor>, Double> {
    private static final long serialVersionUID = 582183815675337782L;
    private String regressorName;

    public RegressionQuery(String regressorName) {
        this.regressorName = regressorName;
    }

    public List<Double> batchRetrieve(MapState<Regressor> state, List<TridentTuple> tuples) {
        ArrayList<Double> labels;
        block4: {
            labels = new ArrayList<Double>();
            List regressors = state.multiGet(KeysUtil.toKeys(this.regressorName));
            if (regressors == null || regressors.isEmpty()) break block4;
            Regressor regressor = (Regressor)regressors.get(0);
            if (regressor == null) {
                for (TridentTuple tuple : tuples) {
                    labels.add(null);
                }
            } else {
                for (TridentTuple tuple : tuples) {
                    Instance instance = (Instance)tuple.get(0);
                    Double label = regressor.predict(instance.features);
                    labels.add(label);
                }
            }
        }
        return labels;
    }

    public void execute(TridentTuple tuple, Double result, TridentCollector collector) {
        collector.emit((List)new Values(new Object[]{result}));
    }
}

