/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.testing;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.Instance;
import java.util.List;
import java.util.Map;
import java.util.Random;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class NANDSpout
implements IBatchSpout {
    private static final long serialVersionUID = -3885109681047850872L;
    private int maxBatchSize = 10;
    private Random random = new Random();

    public void open(Map conf, TopologyContext context) {
    }

    public void emitBatch(long batchId, TridentCollector collector) {
        for (int i = 0; i < this.maxBatchSize; ++i) {
            Instance<Boolean> instance = this.createRandomNAND();
            collector.emit((List)new Values(new Object[]{instance}));
        }
    }

    protected Instance<Boolean> createRandomNAND() {
        Boolean x1 = this.random.nextBoolean();
        Boolean x2 = this.random.nextBoolean();
        Boolean label = x1 == false || x2 == false;
        double[] features = new double[]{1.0, x1 != false ? 1.0 : 0.0, x2 != false ? 1.0 : 0.0};
        return new Instance<Boolean>(label, features);
    }

    protected Double noise(Double value) {
        return value + (this.random.nextDouble() - 0.5) / 5.0;
    }

    public void ack(long batchId) {
    }

    public void close() {
    }

    public Map getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{"instance"});
    }
}

