/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.classification;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.classification.Classifier;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.util.KeysUtil;
import java.util.ArrayList;
import java.util.List;
import storm.trident.operation.TridentCollector;
import storm.trident.state.BaseQueryFunction;
import storm.trident.state.map.MapState;
import storm.trident.tuple.TridentTuple;

public class ClassifyQuery<L>
extends BaseQueryFunction<MapState<Classifier<L>>, L> {
    private static final long serialVersionUID = -9046858936834644113L;
    private String classifierName;

    public ClassifyQuery(String classifierName) {
        this.classifierName = classifierName;
    }

    public List<L> batchRetrieve(MapState<Classifier<L>> state, List<TridentTuple> tuples) {
        ArrayList labels = new ArrayList();
        List classifiers = state.multiGet(KeysUtil.toKeys(this.classifierName));
        if (classifiers != null && !classifiers.isEmpty()) {
            Classifier classifier = (Classifier)classifiers.get(0);
            if (classifier == null) {
                for (int i = 0; i < tuples.size(); ++i) {
                    labels.add(null);
                }
            } else {
                for (TridentTuple tuple : tuples) {
                    Instance instance = (Instance)tuple.get(0);
                    Object label = classifier.classify(instance.features);
                    labels.add(label);
                }
            }
        } else {
            for (int i = 0; i < tuples.size(); ++i) {
                labels.add(null);
            }
        }
        return labels;
    }

    public void execute(TridentTuple tuple, L result, TridentCollector collector) {
        collector.emit((List)new Values(new Object[]{result}));
    }
}

