/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.classification;

import com.github.pmerienne.trident.ml.classification.Classifier;
import com.github.pmerienne.trident.ml.util.MathUtil;

public class WinnowClassifier
implements Classifier<Boolean> {
    private static final long serialVersionUID = -5163481593640555140L;
    private double[] weights;
    public double promotion = 1.5;
    public double demotion = 0.5;
    public double threshold = 1.0;

    public WinnowClassifier() {
    }

    public WinnowClassifier(double promotion, double demotion, double threshold) {
        this.promotion = promotion;
        this.demotion = demotion;
        this.threshold = threshold;
    }

    @Override
    public Boolean classify(double[] features) {
        Double evaluation;
        if (this.weights == null) {
            this.init(features.length);
        }
        Boolean prediction = (evaluation = Double.valueOf(MathUtil.dot(features, this.weights))) >= this.threshold ? Boolean.TRUE : Boolean.FALSE;
        return prediction;
    }

    @Override
    public void update(Boolean label, double[] features) {
        Boolean predictedLabel = this.classify(features);
        if (!label.equals(predictedLabel)) {
            for (int i = 0; i < features.length; ++i) {
                if (!(features[i] * this.weights[i] > 0.0)) continue;
                this.weights[i] = predictedLabel != false ? this.weights[i] * this.demotion : this.weights[i] * this.promotion;
            }
        }
    }

    protected void init(int featureSize) {
        this.weights = new double[featureSize];
        for (int i = 0; i < featureSize; ++i) {
            this.weights[i] = this.threshold / (double)featureSize;
        }
    }

    @Override
    public void reset() {
        this.weights = null;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getPromotion() {
        return this.promotion;
    }

    public void setPromotion(double promotion) {
        this.promotion = promotion;
    }

    public double getDemotion() {
        return this.demotion;
    }

    public void setDemotion(double demotion) {
        this.demotion = demotion;
    }

    public String toString() {
        return "WinnowClassifier [promotion=" + this.promotion + ", demotion=" + this.demotion + ", threshold=" + this.threshold + "]";
    }
}

