/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.evaluation;

import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.evaluation.Evaluation;
import java.util.Objects;
import storm.trident.operation.CombinerAggregator;
import storm.trident.tuple.TridentTuple;

public class AccuracyAggregator<L>
implements CombinerAggregator<AccuracyState<L>> {
    private static final long serialVersionUID = 1136784137149485843L;

    public AccuracyState<L> init(TridentTuple tuple) {
        Instance instance = (Instance)tuple.getValue(0);
        Object prediction = tuple.getValue(1);
        Object expected = instance.getLabel();
        boolean equals = Objects.equals(expected, prediction);
        AccuracyState state = new AccuracyState(1L, equals ? 0L : 1L);
        return state;
    }

    public AccuracyState<L> combine(AccuracyState<L> val1, AccuracyState<L> val2) {
        return new AccuracyState(((AccuracyState)val1).totalCount + ((AccuracyState)val2).totalCount, ((AccuracyState)val1).errorCount + ((AccuracyState)val2).errorCount);
    }

    public AccuracyState<L> zero() {
        return new AccuracyState();
    }

    public static class AccuracyState<L>
    implements Evaluation<L> {
        private static final long serialVersionUID = 938679193655075913L;
        private final Long totalCount;
        private final Long errorCount;

        public AccuracyState() {
            this.totalCount = 0L;
            this.errorCount = 0L;
        }

        public AccuracyState(long totalCount, long errorCount) {
            this.totalCount = totalCount;
            this.errorCount = errorCount;
        }

        @Override
        public double getEvaluation() {
            return 1.0 - this.errorCount.doubleValue() / this.totalCount.doubleValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.errorCount == null ? 0 : this.errorCount.hashCode());
            result = 31 * result + (this.totalCount == null ? 0 : this.totalCount.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccuracyState other = (AccuracyState)obj;
            if (this.errorCount == null ? other.errorCount != null : !this.errorCount.equals(other.errorCount)) {
                return false;
            }
            return !(this.totalCount == null ? other.totalCount != null : !this.totalCount.equals(other.totalCount));
        }

        public String toString() {
            return "AccuracyState [totalCount=" + this.totalCount + ", errorCount=" + this.errorCount + "]";
        }
    }
}

