/*
 * Decompiled with CFR 0.152.
 */
package com.github.pmerienne.trident.ml.preprocessing;

import backtype.storm.tuple.Values;
import com.github.pmerienne.trident.ml.core.Instance;
import com.github.pmerienne.trident.ml.stats.StreamFeatureStatistics;
import com.github.pmerienne.trident.ml.stats.StreamStatistics;
import java.util.List;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.tuple.TridentTuple;

public class StandardScaler
extends BaseFunction {
    private static final long serialVersionUID = 1740717206768121351L;

    public void execute(TridentTuple tuple, TridentCollector collector) {
        Instance instance = (Instance)tuple.get(0);
        StreamStatistics streamStatistics = (StreamStatistics)tuple.get(1);
        Instance<?> standardizedInstance = this.standardize(instance, streamStatistics);
        collector.emit((List)new Values(new Object[]{standardizedInstance}));
    }

    protected Instance<?> standardize(Instance<?> instance, StreamStatistics streamStatistics) {
        int featuresSize = instance.features.length;
        double[] standardizedFeatures = new double[featuresSize];
        for (int i = 0; i < featuresSize; ++i) {
            StreamFeatureStatistics featureStatistics = streamStatistics.getFeaturesStatistics().get(i);
            standardizedFeatures[i] = (instance.features[i] - featureStatistics.getMean()) / featureStatistics.getStdDev();
        }
        Instance standardizedInstance = new Instance(instance.label, standardizedFeatures);
        return standardizedInstance;
    }
}

