(ns clojure-spinners.util.wide-char-ranges
  (:require
    [clojure.string :as str]))

(def wide-char-ranges
  [[169 169]        ;; 00A9 ... 00A9
   [174 174]        ;; 00AE ... 00AE
   [4352 4447]      ;; 1100 ... 115F
   [8252 8252]      ;; 203C ... 203C
   [8265 8265]      ;; 2049 ... 2049
   [8482 8482]      ;; 2122 ... 2122
   [8505 8505]      ;; 2139 ... 2139
   [8596 8601]      ;; 2194 ... 2199
   [8617 8618]      ;; 21A9 ... 21AA
   [8986 8987]      ;; 231A ... 231B
   [9000 9002]      ;; 2328 ... 232A
   [9167 9167]      ;; 23CF ... 23CF
   [9193 9203]      ;; 23E9 ... 23F3
   [9208 9210]      ;; 23F8 ... 23FA
   [9410 9410]      ;; 24C2 ... 24C2
   [9642 9643]      ;; 25AA ... 25AB
   [9654 9654]      ;; 25B6 ... 25B6
   [9664 9664]      ;; 25C0 ... 25C0
   [9723 9726]      ;; 25FB ... 25FE
   [9728 9732]      ;; 2600 ... 2604
   [9742 9742]      ;; 260E ... 260E
   [9745 9745]      ;; 2611 ... 2611
   [9748 9749]      ;; 2614 ... 2615
   [9752 9752]      ;; 2618 ... 2618
   [9757 9757]      ;; 261D ... 261D
   [9760 9760]      ;; 2620 ... 2620
   [9762 9763]      ;; 2622 ... 2623
   [9766 9766]      ;; 2626 ... 2626
   [9770 9770]      ;; 262A ... 262A
   [9774 9775]      ;; 262E ... 262F
   [9784 9786]      ;; 2638 ... 263A
   [9792 9792]      ;; 2640 ... 2640
   [9794 9794]      ;; 2642 ... 2642
   [9800 9811]      ;; 2648 ... 2653
   [9823 9824]      ;; 265F ... 2660
   [9827 9827]      ;; 2663 ... 2663
   [9829 9830]      ;; 2665 ... 2666
   [9832 9832]      ;; 2668 ... 2668
   [9851 9851]      ;; 267B ... 267B
   [9854 9855]      ;; 267E ... 267F
   [9874 9879]      ;; 2692 ... 2697
   [9881 9881]      ;; 2699 ... 2699
   [9883 9884]      ;; 269B ... 269C
   [9888 9889]      ;; 26A0 ... 26A1
   [9895 9895]      ;; 26A7 ... 26A7
   [9898 9899]      ;; 26AA ... 26AB
   [9904 9905]      ;; 26B0 ... 26B1
   [9917 9918]      ;; 26BD ... 26BE
   [9924 9925]      ;; 26C4 ... 26C5
   [9928 9928]      ;; 26C8 ... 26C8
   [9934 9935]      ;; 26CE ... 26CF
   [9937 9937]      ;; 26D1 ... 26D1
   [9939 9940]      ;; 26D3 ... 26D4
   [9961 9962]      ;; 26E9 ... 26EA
   [9968 9973]      ;; 26F0 ... 26F5
   [9975 9978]      ;; 26F7 ... 26FA
   [9981 9981]      ;; 26FD ... 26FD
   [9986 9986]      ;; 2702 ... 2702
   [9989 9989]      ;; 2705 ... 2705
   [9992 9997]      ;; 2708 ... 270D
   [9999 9999]      ;; 270F ... 270F
   [10002 10002]    ;; 2712 ... 2712
   [10004 10004]    ;; 2714 ... 2714
   [10006 10006]    ;; 2716 ... 2716
   [10013 10013]    ;; 271D ... 271D
   [10017 10017]    ;; 2721 ... 2721
   [10024 10024]    ;; 2728 ... 2728
   [10035 10036]    ;; 2733 ... 2734
   [10052 10052]    ;; 2744 ... 2744
   [10055 10055]    ;; 2747 ... 2747
   [10060 10060]    ;; 274C ... 274C
   [10062 10062]    ;; 274E ... 274E
   [10067 10069]    ;; 2753 ... 2755
   [10071 10071]    ;; 2757 ... 2757
   [10083 10084]    ;; 2763 ... 2764
   [10133 10135]    ;; 2795 ... 2797
   [10145 10145]    ;; 27A1 ... 27A1
   [10160 10160]    ;; 27B0 ... 27B0
   [10175 10175]    ;; 27BF ... 27BF
   [10548 10549]    ;; 2934 ... 2935
   [11013 11015]    ;; 2B05 ... 2B07
   [11035 11036]    ;; 2B1B ... 2B1C
   [11088 11088]    ;; 2B50 ... 2B50
   [11093 11093]    ;; 2B55 ... 2B55
   [11904 11929]    ;; 2E80 ... 2E99
   [11931 12019]    ;; 2E9B ... 2EF3
   [12032 12245]    ;; 2F00 ... 2FD5
   [12272 12283]    ;; 2FF0 ... 2FFB
   [12288 12350]    ;; 3000 ... 303E
   [12353 12438]    ;; 3041 ... 3096
   [12441 12543]    ;; 3099 ... 30FF
   [12549 12591]    ;; 3105 ... 312F
   [12593 12686]    ;; 3131 ... 318E
   [12688 12771]    ;; 3190 ... 31E3
   [12784 12830]    ;; 31F0 ... 321E
   [12832 12871]    ;; 3220 ... 3247
   [12880 12951]    ;; 3250 ... 3297
   [12953 12953]    ;; 3299 ... 3299
   [12977 19903]    ;; 32B1 ... 4DBF
   [19968 42124]    ;; 4E00 ... A48C
   [42128 42182]    ;; A490 ... A4C6
   [43360 43388]    ;; A960 ... A97C
   [44032 55203]    ;; AC00 ... D7A3
   [63744 64255]    ;; F900 ... FAFF
   [65040 65049]    ;; FE10 ... FE19
   [65072 65106]    ;; FE30 ... FE52
   [65108 65126]    ;; FE54 ... FE66
   [65128 65131]    ;; FE68 ... FE6B
   [65281 65376]    ;; FF01 ... FF60
   [65504 65510]    ;; FFE0 ... FFE6
   [94176 94180]    ;; 16FE0 ... 16FE4
   [94192 94193]    ;; 16FF0 ... 16FF1
   [94208 100343]   ;; 17000 ... 187F7
   [100352 101589]  ;; 18800 ... 18CD5
   [101632 101640]  ;; 18D00 ... 18D08
   [110592 110878]  ;; 1B000 ... 1B11E
   [110928 110930]  ;; 1B150 ... 1B152
   [110948 110951]  ;; 1B164 ... 1B167
   [110960 111355]  ;; 1B170 ... 1B2FB
   [126980 126980]  ;; 1F004 ... 1F004
   [127183 127183]  ;; 1F0CF ... 1F0CF
   [127344 127345]  ;; 1F170 ... 1F171
   [127358 127359]  ;; 1F17E ... 1F17F
   [127374 127374]  ;; 1F18E ... 1F18E
   [127377 127386]  ;; 1F191 ... 1F19A
   [127488 127490]  ;; 1F200 ... 1F202
   [127504 127514]  ;; 1F210 ... 1F21A
   [127535 127535]  ;; 1F22F ... 1F22F
   [127538 127546]  ;; 1F232 ... 1F23A
   [127552 127560]  ;; 1F240 ... 1F248
   [127568 127569]  ;; 1F250 ... 1F251
   [127584 127589]  ;; 1F260 ... 1F265
   [127744 127777]  ;; 1F300 ... 1F321
   [127780 127891]  ;; 1F324 ... 1F393
   [127894 127895]  ;; 1F396 ... 1F397
   [127897 127899]  ;; 1F399 ... 1F39B
   [127902 127984]  ;; 1F39E ... 1F3F0
   [127987 127989]  ;; 1F3F3 ... 1F3F5
   [127991 128253]  ;; 1F3F7 ... 1F4FD
   [128255 128317]  ;; 1F4FF ... 1F53D
   [128329 128334]  ;; 1F549 ... 1F54E
   [128336 128359]  ;; 1F550 ... 1F567
   [128367 128368]  ;; 1F56F ... 1F570
   [128371 128378]  ;; 1F573 ... 1F57A
   [128391 128391]  ;; 1F587 ... 1F587
   [128394 128397]  ;; 1F58A ... 1F58D
   [128400 128400]  ;; 1F590 ... 1F590
   [128405 128406]  ;; 1F595 ... 1F596
   [128420 128421]  ;; 1F5A4 ... 1F5A5
   [128424 128424]  ;; 1F5A8 ... 1F5A8
   [128433 128434]  ;; 1F5B1 ... 1F5B2
   [128444 128444]  ;; 1F5BC ... 1F5BC
   [128450 128452]  ;; 1F5C2 ... 1F5C4
   [128465 128467]  ;; 1F5D1 ... 1F5D3
   [128476 128478]  ;; 1F5DC ... 1F5DE
   [128481 128481]  ;; 1F5E1 ... 1F5E1
   [128483 128483]  ;; 1F5E3 ... 1F5E3
   [128488 128488]  ;; 1F5E8 ... 1F5E8
   [128495 128495]  ;; 1F5EF ... 1F5EF
   [128499 128499]  ;; 1F5F3 ... 1F5F3
   [128506 128591]  ;; 1F5FA ... 1F64F
   [128640 128709]  ;; 1F680 ... 1F6C5
   [128715 128722]  ;; 1F6CB ... 1F6D2
   [128725 128727]  ;; 1F6D5 ... 1F6D7
   [128736 128741]  ;; 1F6E0 ... 1F6E5
   [128745 128745]  ;; 1F6E9 ... 1F6E9
   [128747 128748]  ;; 1F6EB ... 1F6EC
   [128752 128752]  ;; 1F6F0 ... 1F6F0
   [128755 128764]  ;; 1F6F3 ... 1F6FC
   [128992 129003]  ;; 1F7E0 ... 1F7EB
   [129292 129338]  ;; 1F90C ... 1F93A
   [129340 129349]  ;; 1F93C ... 1F945
   [129351 129400]  ;; 1F947 ... 1F978
   [129402 129483]  ;; 1F97A ... 1F9CB
   [129485 129535]  ;; 1F9CD ... 1F9FF
   [129648 129652]  ;; 1FA70 ... 1FA74
   [129656 129658]  ;; 1FA78 ... 1FA7A
   [129664 129670]  ;; 1FA80 ... 1FA86
   [129680 129704]  ;; 1FA90 ... 1FAA8
   [129712 129718]  ;; 1FAB0 ... 1FAB6
   [129728 129730]  ;; 1FAC0 ... 1FAC2
   [129744 129750]  ;; 1FAD0 ... 1FAD6
   [131072 196605]  ;; 20000 ... 2FFFD
   [196608 262141]  ;; 30000 ... 3FFFD
   ])

(def regional-indicator-symbols
  [127462 127487] ;; 1f1e6 ... 1f1ff
  )

(defn code-point->int
  [code-point]
  (Integer/parseInt code-point 16))

(defn ris?
  [cp]
  (let [[ris-s ris-e] regional-indicator-symbols]
    (<= ris-s cp ris-e)))

(defn country-flag?
  [c]
  (and
    (= (.length c) 4)
    (= 2 (.codePointCount c 0 (.length c)))
    (ris? (.codePointAt c 0))
    (ris? (.codePointAt c 2))))

(defn wide-char?
  "code-point := int"
  [code-point]
  (let [[min-point _] (first wide-char-ranges)
        [_ max-point] (last wide-char-ranges)]
    (if (< min-point code-point max-point)
      (loop [vecs wide-char-ranges]
        (if-let [[s e] (first vecs)]
          (if (<= s code-point e)
            true
            (recur (rest vecs)))
          false))
      false)))
