/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.bukkit;

import com.github.puregero.multilib.DataStorageImpl;
import com.github.puregero.multilib.MultiLibImpl;
import com.github.puregero.multilib.bukkit.BukkitDataStorageImpl;
import com.github.puregero.multilib.bukkit.StoredData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitImpl
implements MultiLibImpl {
    private final Map<UUID, StoredData> data = new HashMap<UUID, StoredData>();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    private final BukkitDataStorageImpl dataStorage = new BukkitDataStorageImpl(this);
    private final Map<String, List<BiConsumer<byte[], BiConsumer<String, byte[]>>>> notificationListeners = new ConcurrentHashMap<String, List<BiConsumer<byte[], BiConsumer<String, byte[]>>>>();

    public BukkitImpl() {
        final JavaPlugin plugin = JavaPlugin.getProvidingPlugin(this.getClass());
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onDisable(PluginDisableEvent event) {
                if (event.getPlugin() == plugin) {
                    BukkitImpl.this.data.forEach((key, value) -> value.save());
                }
            }
        }, (Plugin)plugin);
    }

    public boolean isChunkExternal(World world, int cx, int cz) {
        return false;
    }

    public boolean isChunkExternal(Location location) {
        return false;
    }

    public boolean isChunkExternal(Entity entity) {
        return false;
    }

    public boolean isChunkExternal(Block block) {
        return false;
    }

    public boolean isChunkExternal(Chunk chunk) {
        return false;
    }

    public boolean isChunkLocal(World world, int cx, int cz) {
        return true;
    }

    public boolean isChunkLocal(Location location) {
        return true;
    }

    public boolean isChunkLocal(Entity entity) {
        return true;
    }

    public boolean isChunkLocal(Block block) {
        return true;
    }

    public boolean isChunkLocal(Chunk chunk) {
        return true;
    }

    public boolean isExternalPlayer(Player player) {
        return false;
    }

    public boolean isLocalPlayer(Player player) {
        return true;
    }

    @NotNull
    public String getLocalServerName() {
        return "bukkit";
    }

    public String getExternalServerName(Player player) {
        return null;
    }

    public String getData(Player player, String key) {
        return this.data.containsKey(player.getUniqueId()) ? this.data.get(player.getUniqueId()).getData(player, key) : null;
    }

    public void setData(Player player, String key, String value) {
        this.data.computeIfAbsent(player.getUniqueId(), playerKey -> new StoredData(player.getUniqueId(), player.getLastPlayed(), this.scheduler)).setData(player, key, value);
    }

    public String getPersistentData(Player player, String key) {
        return this.data.containsKey(player.getUniqueId()) ? this.data.get(player.getUniqueId()).getPersistentData(key) : null;
    }

    public void setPersistentData(Player player, String key, String value) {
        this.data.computeIfAbsent(player.getUniqueId(), playerKey -> new StoredData(player.getUniqueId(), player.getLastPlayed(), this.scheduler)).setPersistentData(key, value);
    }

    public void on(Plugin plugin, String channel, Consumer<byte[]> callback) {
        this.notificationListeners.computeIfAbsent(channel, key -> new ArrayList()).add((data, reply) -> callback.accept((byte[])data));
    }

    public void on(Plugin plugin, String channel, BiConsumer<byte[], BiConsumer<String, byte[]>> callbackWithReply) {
        this.notificationListeners.computeIfAbsent(channel, key -> new ArrayList()).add(callbackWithReply);
    }

    public void notify(String channel, byte[] data) {
    }

    public void notify(Chunk chunk, String channel, byte[] data) {
    }

    public void notifyOwningServer(Chunk chunk, String channel, byte[] data) {
        this.processNotification(channel, data);
    }

    public void notifyOwningServer(Player player, String channel, byte[] data) {
        this.processNotification(channel, data);
    }

    private void processNotification(String channel, byte[] data) {
        this.notificationListeners.getOrDefault(channel, Collections.emptyList()).forEach(listener -> listener.accept(data, (replyChannel, replyData) -> this.processNotification((String)replyChannel, (byte[])replyData)));
    }

    public void chatOnOtherServers(Player player, String message) {
    }

    public Collection<? extends Player> getAllOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    public DataStorageImpl getDataStorage() {
        return this.dataStorage;
    }
}

