/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.SkinParts;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.NotNull;

public class PlayerClientOptionsChangeEvent
extends PlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private final String locale;
    private final int viewDistance;
    private final ClientOption.ChatVisibility chatVisibility;
    private final boolean chatColors;
    private final SkinParts skinparts;
    private final MainHand mainHand;

    public PlayerClientOptionsChangeEvent(@NotNull Player player, @NotNull String locale, int viewDistance, @NotNull ClientOption.ChatVisibility chatVisibility, boolean chatColors, @NotNull SkinParts skinParts, @NotNull MainHand mainHand) {
        super(player);
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatVisibility = chatVisibility;
        this.chatColors = chatColors;
        this.skinparts = skinParts;
        this.mainHand = mainHand;
    }

    @NotNull
    public String getLocale() {
        return this.locale;
    }

    public boolean hasLocaleChanged() {
        return !this.locale.equals(this.player.getClientOption(ClientOption.LOCALE));
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean hasViewDistanceChanged() {
        return this.viewDistance != this.player.getClientOption(ClientOption.VIEW_DISTANCE);
    }

    @NotNull
    public ClientOption.ChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public boolean hasChatVisibilityChanged() {
        return this.chatVisibility != this.player.getClientOption(ClientOption.CHAT_VISIBILITY);
    }

    public boolean hasChatColorsEnabled() {
        return this.chatColors;
    }

    public boolean hasChatColorsEnabledChanged() {
        return this.chatColors != this.player.getClientOption(ClientOption.CHAT_COLORS_ENABLED);
    }

    @NotNull
    public SkinParts getSkinParts() {
        return this.skinparts;
    }

    public boolean hasSkinPartsChanged() {
        return this.skinparts.getRaw() != this.player.getClientOption(ClientOption.SKIN_PARTS).getRaw();
    }

    @NotNull
    public MainHand getMainHand() {
        return this.mainHand;
    }

    public boolean hasMainHandChanged() {
        return this.mainHand != this.player.getClientOption(ClientOption.MAIN_HAND);
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

