/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import io.papermc.paper.util.TransformingRandomAccessList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.string.StringExaminer;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncTabCompleteEvent
extends Event
implements Cancellable {
    @NotNull
    private final CommandSender sender;
    @NotNull
    private final String buffer;
    private final boolean isCommand;
    @Nullable
    private final Location loc;
    private final List<Completion> completions = new ArrayList<Completion>();
    private final List<String> stringCompletions = new TransformingRandomAccessList<Completion, String>(this.completions, Completion::suggestion, Completion::completion);
    private boolean cancelled;
    private boolean handled = false;
    private boolean fireSyncHandler = true;
    private static final HandlerList handlers = new HandlerList();

    public AsyncTabCompleteEvent(@NotNull CommandSender sender, @NotNull String buffer, boolean isCommand, @Nullable Location loc) {
        super(true);
        this.sender = sender;
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.loc = loc;
    }

    @Deprecated
    public AsyncTabCompleteEvent(@NotNull CommandSender sender, @NotNull List<String> completions, @NotNull String buffer, boolean isCommand, @Nullable Location loc) {
        super(true);
        this.sender = sender;
        this.completions.addAll(AsyncTabCompleteEvent.fromStrings(completions));
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.loc = loc;
    }

    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @NotNull
    public List<String> getCompletions() {
        return this.stringCompletions;
    }

    public void setCompletions(@NotNull List<String> completions) {
        if (completions == this.stringCompletions) {
            return;
        }
        Validate.notNull(completions);
        this.completions.clear();
        this.completions.addAll(AsyncTabCompleteEvent.fromStrings(completions));
    }

    @NotNull
    public List<Completion> completions() {
        return this.completions;
    }

    public void completions(@NotNull List<Completion> newCompletions) {
        Validate.notNull(newCompletions, (String)"new completions");
        this.completions.clear();
        this.completions.addAll(newCompletions);
    }

    @NotNull
    public String getBuffer() {
        return this.buffer;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    @Nullable
    public Location getLocation() {
        return this.loc;
    }

    public boolean isHandled() {
        return !this.completions.isEmpty() || this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    private static List<Completion> fromStrings(@NotNull List<String> strings) {
        ArrayList<Completion> list = new ArrayList<Completion>();
        for (String it : strings) {
            list.add(new CompletionImpl(it, null));
        }
        return list;
    }

    static final class CompletionImpl
    implements Completion {
        private final String suggestion;
        private final Component tooltip;

        CompletionImpl(@NotNull String suggestion, @Nullable Component tooltip) {
            this.suggestion = suggestion;
            this.tooltip = tooltip;
        }

        @Override
        @NotNull
        public String suggestion() {
            return this.suggestion;
        }

        @Override
        @Nullable
        public Component tooltip() {
            return this.tooltip;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletionImpl that = (CompletionImpl)o;
            return this.suggestion.equals(that.suggestion) && Objects.equals(this.tooltip, that.tooltip);
        }

        public int hashCode() {
            return Objects.hash(this.suggestion, this.tooltip);
        }

        @NotNull
        public String toString() {
            return (String)StringExaminer.simpleEscaping().examine((Examinable)this);
        }
    }

    public static interface Completion
    extends Examinable {
        @NotNull
        public String suggestion();

        @Nullable
        public Component tooltip();

        @NotNull
        default public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"suggestion", (String)this.suggestion()), ExaminableProperty.of((String)"tooltip", (Object)this.tooltip()));
        }

        @NotNull
        public static Completion completion(@NotNull String suggestion) {
            return new CompletionImpl(suggestion, null);
        }

        @NotNull
        public static Completion completion(@NotNull String suggestion, @Nullable Component tooltip) {
            return new CompletionImpl(suggestion, tooltip);
        }
    }
}

