package org.bukkit.entity;

import org.jetbrains.annotations.NotNull;

/**
 * Panda entity.
 */
public interface Panda extends Animals, Sittable { // Paper

    /**
     * Gets this Panda's main gene.
     *
     * @return main gene
     */
    @NotNull
    Gene getMainGene();

    /**
     * Sets this Panda's main gene.
     *
     * @param gene main gene
     */
    void setMainGene(@NotNull Gene gene);

    /**
     * Gets this Panda's hidden gene.
     *
     * @return hidden gene
     */
    @NotNull
    Gene getHiddenGene();

    /**
     * Sets this Panda's hidden gene.
     *
     * @param gene hidden gene
     */
    void setHiddenGene(@NotNull Gene gene);

    public enum Gene {

        NORMAL(false),
        LAZY(false),
        WORRIED(false),
        PLAYFUL(false),
        BROWN(true),
        WEAK(true),
        AGGRESSIVE(false);

        private final boolean recessive;

        private Gene(boolean recessive) {
            this.recessive = recessive;
        }

        /**
         * Gets whether this gene is recessive, i.e. required in both parents to
         * propagate to children.
         *
         * @return recessive status
         */
        public boolean isRecessive() {
            return recessive;
        }
    }

    // Paper start - Panda API
    /**
     * Sets the sneeze progress in this animation.
     * This value counts up only if {@link Panda#isSneezing()} is true
     *
     * @param ticks sneeze progress
     */
    void setSneezeTicks(int ticks);

    /**
     * Gets the current sneeze progress, or how many ticks this panda will sneeze for.
     *
     * @return sneeze progress
     */
    int getSneezeTicks();

    /**
     * Sets if the panda is sneezing, which causes the sneeze counter to count.
     * <p>
     * When false, this will automatically set the sneeze ticks to 0.
     *
     * @param sneeze if the panda is sneezing or not
     */
    void setSneezing(boolean sneeze);

    /**
     * Gets if the panda is sneezing
     *
     * @return is sneezing
     */
    boolean isSneezing();

    /**
     * Sets the eating ticks for this panda.
     * <p>
     *
     * This starts counting up as long as it is greater than 0.
     *
     * @param ticks eating ticks
     */
    void setEatingTicks(int ticks);

    /**
     * Gets the current eating progress, or how many ticks this panda has been eating for.
     *
     * @return eating progress
     */
    int getEatingTicks();

    /**
     * Sets the number of ticks this panda will be unhappy for.
     * <p>
     * This value counts down.
     *
     * @param ticks unhappy ticks
     */
    void setUnhappyTicks(int ticks);

    /**
     * Gets how many ticks this panda will be unhappy for.
     *
     * @return unhappy ticks
     */
    int getUnhappyTicks();

    /**
     * Sets if this panda is currently rolling.
     *
     * @param rolling should roll
     */
    void setRolling(boolean rolling);

    /**
     * Gets if this panda is currently rolling on the ground.
     *
     * @return is rolling
     */
    boolean isRolling();

    /**
     * Sets if this panda is currently on its back.
     *
     * @param onBack is on its back
     */
    void setIsOnBack(boolean onBack);

    /**
     * Gets if this panda is currently on its back.
     *
     * @return is on back
     */
    boolean isOnBack();

    /**
     * Sets if this panda is currently sitting.
     *
     * @param sitting is currently sitting
     * @deprecated use {@link #setSitting(boolean)}
     */
    @Deprecated(forRemoval = true)
    default void setIsSitting(boolean sitting) {
        this.setSitting(sitting);
    }

    /**
     * Sets if this panda is currently sitting.
     *
     * @param sitting is currently sitting
     */
    @Override
    void setSitting(boolean sitting);

    /**
     * Gets if this panda is sitting.
     *
     * @return is sitting
     */
    @Override
    boolean isSitting();
    // Paper end - Panda API
}
