/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.util;

import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> backingMap;
    private final Function<K, V> loader;

    public LoadingMap(@NotNull Map<K, V> backingMap, @NotNull Function<K, V> loader) {
        this.backingMap = backingMap;
        this.loader = loader;
    }

    @NotNull
    public static <K, V> Map<K, V> of(@NotNull Map<K, V> backingMap, @NotNull Function<K, V> loader) {
        return new LoadingMap<K, V>(backingMap, loader);
    }

    @NotNull
    public static <K, V> Map<K, V> newAutoMap(@NotNull Map<K, V> backingMap, @Nullable Class<? extends K> keyClass, @NotNull Class<? extends V> valueClass) {
        return new LoadingMap<K, V>(backingMap, new AutoInstantiatingLoader<K, V>(keyClass, valueClass));
    }

    @NotNull
    public static <K, V> Map<K, V> newAutoMap(@NotNull Map<K, V> backingMap, @NotNull Class<? extends V> valueClass) {
        return LoadingMap.newAutoMap(backingMap, null, valueClass);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashAutoMap(@Nullable Class<? extends K> keyClass, @NotNull Class<? extends V> valueClass) {
        return LoadingMap.newAutoMap(new HashMap(), keyClass, valueClass);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashAutoMap(@NotNull Class<? extends V> valueClass) {
        return LoadingMap.newHashAutoMap(null, valueClass);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashAutoMap(@Nullable Class<? extends K> keyClass, @NotNull Class<? extends V> valueClass, int initialCapacity, float loadFactor) {
        return LoadingMap.newAutoMap(new HashMap(initialCapacity, loadFactor), keyClass, valueClass);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashAutoMap(@NotNull Class<? extends V> valueClass, int initialCapacity, float loadFactor) {
        return LoadingMap.newHashAutoMap(null, valueClass, initialCapacity, loadFactor);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Function<K, V> loader) {
        return new LoadingMap(new HashMap(), loader);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Function<K, V> loader, int initialCapacity) {
        return new LoadingMap(new HashMap(initialCapacity), loader);
    }

    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Function<K, V> loader, int initialCapacity, float loadFactor) {
        return new LoadingMap(new HashMap(initialCapacity, loadFactor), loader);
    }

    @NotNull
    public static <K, V> Map<K, V> newIdentityHashMap(@NotNull Function<K, V> loader) {
        return new LoadingMap(new IdentityHashMap(), loader);
    }

    @NotNull
    public static <K, V> Map<K, V> newIdentityHashMap(@NotNull Function<K, V> loader, int initialCapacity) {
        return new LoadingMap(new IdentityHashMap(initialCapacity), loader);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        V v = this.backingMap.get(key);
        if (v != null) {
            return v;
        }
        return this.backingMap.computeIfAbsent(key, this.loader);
    }

    @Override
    @Nullable
    public V put(@Nullable K key, @Nullable V value) {
        return this.backingMap.put(key, value);
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.backingMap.putAll(m);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.backingMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    @NotNull
    public LoadingMap<K, V> clone() {
        return new LoadingMap<K, V>(this.backingMap, this.loader);
    }

    private static class AutoInstantiatingLoader<K, V>
    implements Function<K, V> {
        final Constructor<? extends V> constructor;
        private final Class<? extends V> valueClass;

        AutoInstantiatingLoader(@Nullable Class<? extends K> keyClass, @NotNull Class<? extends V> valueClass) {
            try {
                this.valueClass = valueClass;
                this.constructor = keyClass != null ? valueClass.getConstructor(keyClass) : null;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(valueClass.getName() + " does not have a constructor for " + (keyClass != null ? keyClass.getName() : null));
            }
        }

        @Override
        @NotNull
        public V apply(@Nullable K input) {
            try {
                return this.constructor != null ? this.constructor.newInstance(input) : this.valueClass.newInstance();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    public static abstract class Feeder<T>
    implements Function<T, T> {
        @Override
        @Nullable
        public T apply(@Nullable Object input) {
            return this.apply();
        }

        @Nullable
        public abstract T apply();
    }
}

